/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.core.client;

import java.util.logging.Logger;
import net.accelbyte.sdk.api.lobby.ws_models.ConnectNotif;
import net.accelbyte.sdk.core.client.BaseWebSocketClient;
import net.accelbyte.sdk.core.client.TokenRepositoryCallbackListener;
import net.accelbyte.sdk.core.repository.ConfigRepository;
import net.accelbyte.sdk.core.repository.TokenRepository;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class LobbyWebSocketClient
extends BaseWebSocketClient {
    private static final Logger log = Logger.getLogger(LobbyWebSocketClient.class.getName());
    public static String LOBBY_SESSION_ID_DATAMAP_KEY = "lobbySessionId";
    private static String WS_SERVICE_PATH_NAME = "lobby";
    private TokenRepositoryCallbackListener tokenRepositoryCallbackListener;

    public static LobbyWebSocketClient create(ConfigRepository configRepository, TokenRepository tokenRepository, WebSocketListener listener) throws Exception {
        LobbyWebSocketClient webSocketClient = new LobbyWebSocketClient(configRepository, tokenRepository, listener, 0, -1, 0);
        return webSocketClient;
    }

    public static LobbyWebSocketClient create(ConfigRepository configRepository, TokenRepository tokenRepository, WebSocketListener listener, int reconnectDelayMs, int maxNumReconnectAttempts, int pingIntervalMs) throws Exception {
        LobbyWebSocketClient webSocketClient = new LobbyWebSocketClient(configRepository, tokenRepository, listener, reconnectDelayMs, maxNumReconnectAttempts, pingIntervalMs);
        return webSocketClient;
    }

    public LobbyWebSocketClient(ConfigRepository configRepository, TokenRepository tokenRepository, WebSocketListener webSocketListener, int reconnectDelayMs, int maxNumReconnectAttempts, int pingIntervalMs) throws Exception {
        super(configRepository, tokenRepository, webSocketListener, reconnectDelayMs, maxNumReconnectAttempts, pingIntervalMs, WS_SERVICE_PATH_NAME);
        this.tokenRepositoryCallbackListener = new TokenRepositoryCallbackListener(tokenRepository, this);
    }

    public void onMessage(WebSocket webSocket, String text) {
        if (text.contains(ConnectNotif.getType())) {
            ConnectNotif notif = ConnectNotif.createFromWSM(text);
            String lobbySessionId = notif.getLobbySessionID();
            log.info("lobbySessionID: " + lobbySessionId);
            this.setData(LOBBY_SESSION_ID_DATAMAP_KEY, lobbySessionId);
        }
        super.onMessage(webSocket, text);
    }

    public void connect(boolean isReconnecting) throws Exception {
        if (isReconnecting && this.hasData(LOBBY_SESSION_ID_DATAMAP_KEY)) {
            String lobbySessionId = (String)this.getData(LOBBY_SESSION_ID_DATAMAP_KEY);
            this.headers.put("X-Ab-LobbySessionID", lobbySessionId);
        }
        super.connect(isReconnecting);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.numReconnectAttempts = 0;
        this.isSocketConnected = true;
        log.info("Websocket is opened successfully");
        this.registerCallbacks();
        this.webSocketListener.onOpen(webSocket, response);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.unregisterCallbacks();
        super.onClosing(webSocket, code, reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.unregisterCallbacks();
        super.onFailure(webSocket, t, response);
    }

    private void registerCallbacks() {
        this.tokenRepositoryCallbackListener.registerCallback();
    }

    private void unregisterCallbacks() {
        this.tokenRepositoryCallbackListener.unregisterCallback();
    }
}

