/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.core.client;

import java.util.logging.Logger;
import net.accelbyte.sdk.api.lobby.ws_models.RefreshTokenRequest;
import net.accelbyte.sdk.core.client.BaseWebSocketClient;
import net.accelbyte.sdk.core.repository.TokenRepository;
import net.accelbyte.sdk.core.repository.TokenRepositoryCallback;
import net.accelbyte.sdk.core.util.Helper;

public class TokenRepositoryCallbackListener
extends TokenRepositoryCallback {
    private static final Logger log = Logger.getLogger(TokenRepositoryCallbackListener.class.getName());
    private final TokenRepository tokenRepository;
    private final BaseWebSocketClient baseWebSocketClient;

    public TokenRepositoryCallbackListener(TokenRepository tokenRepository, BaseWebSocketClient baseWebSocketClient) {
        this.tokenRepository = tokenRepository;
        this.baseWebSocketClient = baseWebSocketClient;
    }

    public void onAccessTokenRefreshed(String newToken) {
        log.info("onAccessTokenRefreshed: " + newToken);
        RefreshTokenRequest request = RefreshTokenRequest.builder().id(Helper.generateUUID()).token(newToken).build();
        this.baseWebSocketClient.sendMessage(request.toWSM());
    }

    public void registerCallback() {
        log.info("registerTokenRepositoryCallback");
        this.tokenRepository.registerTokenRepositoryCallback((TokenRepositoryCallback)this);
    }

    public void unregisterCallback() {
        log.info("unregisterTokenRepositoryCallback");
        this.tokenRepository.unregisterTokenRepositoryCallback((TokenRepositoryCallback)this);
    }
}

