/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.matchmaking.operations.matchmaking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.matchmaking.models.ModelsMatchmakingResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class BulkGetSessions
extends Operation {
    private String path = "/matchmaking/v1/admin/namespaces/{namespace}/channels/all/sessions/bulk";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String matchIDs;

    @Deprecated
    public BulkGetSessions(String customBasePath, String namespace, String matchIDs) {
        this.namespace = namespace;
        this.matchIDs = matchIDs;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("matchIDs", this.matchIDs == null ? null : Arrays.asList(this.matchIDs));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public List<ModelsMatchmakingResult> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<ModelsMatchmakingResult>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("matchIDs", "None");
        return result;
    }

    public static BulkGetSessionsBuilder builder() {
        return new BulkGetSessionsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getMatchIDs() {
        return this.matchIDs;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMatchIDs(String matchIDs) {
        this.matchIDs = matchIDs;
    }

    public static class BulkGetSessionsBuilder {
        private String customBasePath;
        private String namespace;
        private String matchIDs;

        BulkGetSessionsBuilder() {
        }

        public BulkGetSessionsBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public BulkGetSessionsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public BulkGetSessionsBuilder matchIDs(String matchIDs) {
            this.matchIDs = matchIDs;
            return this;
        }

        public BulkGetSessions build() {
            return new BulkGetSessions(this.customBasePath, this.namespace, this.matchIDs);
        }

        public String toString() {
            return "BulkGetSessions.BulkGetSessionsBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", matchIDs=" + this.matchIDs + ")";
        }
    }
}

