/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.matchmaking.operations.matchmaking;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteChannelHandler
extends Operation {
    private String path = "/matchmaking/namespaces/{namespace}/channels/{channel}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channel;
    private String namespace;

    @Deprecated
    public DeleteChannelHandler(String customBasePath, String channel, String namespace) {
        this.channel = channel;
        this.namespace = namespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channel != null) {
            pathParams.put("channel", this.channel);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.channel == null) {
            return false;
        }
        return this.namespace != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static DeleteChannelHandlerBuilder builder() {
        return new DeleteChannelHandlerBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class DeleteChannelHandlerBuilder {
        private String customBasePath;
        private String channel;
        private String namespace;

        DeleteChannelHandlerBuilder() {
        }

        public DeleteChannelHandlerBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public DeleteChannelHandlerBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public DeleteChannelHandlerBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteChannelHandler build() {
            return new DeleteChannelHandler(this.customBasePath, this.channel, this.namespace);
        }

        public String toString() {
            return "DeleteChannelHandler.DeleteChannelHandlerBuilder(customBasePath=" + this.customBasePath + ", channel=" + this.channel + ", namespace=" + this.namespace + ")";
        }
    }
}

