/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.matchmaking.operations.matchmaking;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.matchmaking.models.ModelsImportConfigResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class ImportChannels
extends Operation {
    private String path = "/matchmaking/v1/admin/namespaces/{namespace}/channels/import";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("multipart/form-data");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private File file;
    private String strategy;

    @Deprecated
    public ImportChannels(String customBasePath, String namespace, File file, String strategy) {
        this.namespace = namespace;
        this.file = file;
        this.strategy = strategy;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, Object> getFormParams() {
        HashMap<String, Object> formDataParams = new HashMap<String, Object>();
        if (this.file != null) {
            formDataParams.put("file", this.file);
        }
        if (this.strategy != null) {
            formDataParams.put("strategy", this.strategy);
        }
        return formDataParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsImportConfigResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsImportConfigResponse().createFromJson(json);
    }

    public static ImportChannelsBuilder builder() {
        return new ImportChannelsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public File getFile() {
        return this.file;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public static class ImportChannelsBuilder {
        private String customBasePath;
        private String namespace;
        private File file;
        private String strategy;

        ImportChannelsBuilder() {
        }

        public ImportChannelsBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public ImportChannelsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ImportChannelsBuilder file(File file) {
            this.file = file;
            return this;
        }

        public ImportChannelsBuilder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public ImportChannels build() {
            return new ImportChannels(this.customBasePath, this.namespace, this.file, this.strategy);
        }

        public String toString() {
            return "ImportChannels.ImportChannelsBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", file=" + this.file + ", strategy=" + this.strategy + ")";
        }
    }
}

