/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.matchmaking.operations.matchmaking;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.matchmaking.models.ModelsMatchmakingResult;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QuerySessionHandler
extends Operation {
    private String path = "/matchmaking/namespaces/{namespace}/sessions/{matchID}/status";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String matchID;
    private String namespace;

    @Deprecated
    public QuerySessionHandler(String customBasePath, String matchID, String namespace) {
        this.matchID = matchID;
        this.namespace = namespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.matchID != null) {
            pathParams.put("matchID", this.matchID);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.matchID == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsMatchmakingResult parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsMatchmakingResult().createFromJson(json);
    }

    public static QuerySessionHandlerBuilder builder() {
        return new QuerySessionHandlerBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getMatchID() {
        return this.matchID;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setMatchID(String matchID) {
        this.matchID = matchID;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class QuerySessionHandlerBuilder {
        private String customBasePath;
        private String matchID;
        private String namespace;

        QuerySessionHandlerBuilder() {
        }

        public QuerySessionHandlerBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public QuerySessionHandlerBuilder matchID(String matchID) {
            this.matchID = matchID;
            return this;
        }

        public QuerySessionHandlerBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QuerySessionHandler build() {
            return new QuerySessionHandler(this.customBasePath, this.matchID, this.namespace);
        }

        public String toString() {
            return "QuerySessionHandler.QuerySessionHandlerBuilder(customBasePath=" + this.customBasePath + ", matchID=" + this.matchID + ", namespace=" + this.namespace + ")";
        }
    }
}

