/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.matchmaking.wrappers;

import java.util.List;
import net.accelbyte.sdk.api.matchmaking.models.LogAppMessageDeclaration;
import net.accelbyte.sdk.api.matchmaking.operations.matchmaking_operations.GetHealthcheckInfo;
import net.accelbyte.sdk.api.matchmaking.operations.matchmaking_operations.HandlerV3Healthz;
import net.accelbyte.sdk.api.matchmaking.operations.matchmaking_operations.PublicGetMessages;
import net.accelbyte.sdk.api.matchmaking.operations.matchmaking_operations.VersionCheckHandler;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class MatchmakingOperations {
    private RequestRunner sdk;
    private String customBasePath = "";

    public MatchmakingOperations(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("matchmaking");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public MatchmakingOperations(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public void getHealthcheckInfo(GetHealthcheckInfo input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void handlerV3Healthz(HandlerV3Healthz input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<LogAppMessageDeclaration> publicGetMessages(PublicGetMessages input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void versionCheckHandler(VersionCheckHandler input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

