/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.matchmaking.wrappers;

import java.util.List;
import net.accelbyte.sdk.api.matchmaking.models.ModelsGetMockMatchesResponse;
import net.accelbyte.sdk.api.matchmaking.models.ModelsGetMockTicketsResponse;
import net.accelbyte.sdk.api.matchmaking.models.ModelsMockTicket;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.BulkCreateMockTickets;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.CleanAllMocks;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.CreateMockTickets;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.GetAllMockMatches;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.GetAllMockTickets;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.GetMockMatchesByTimestamp;
import net.accelbyte.sdk.api.matchmaking.operations.mock_matchmaking.GetMockTicketsByTimestamp;
import net.accelbyte.sdk.core.HttpResponse;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.RequestRunner;

public class MockMatchmaking {
    private RequestRunner sdk;
    private String customBasePath = "";

    public MockMatchmaking(RequestRunner sdk) {
        this.sdk = sdk;
        String configCustomBasePath = sdk.getSdkConfiguration().getConfigRepository().getCustomServiceBasePath("matchmaking");
        if (!configCustomBasePath.equals("")) {
            this.customBasePath = configCustomBasePath;
        }
    }

    public MockMatchmaking(RequestRunner sdk, String customBasePath) {
        this.sdk = sdk;
        this.customBasePath = customBasePath;
    }

    public void cleanAllMocks(CleanAllMocks input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelsGetMockMatchesResponse getAllMockMatches(GetAllMockMatches input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelsGetMockMatchesResponse getMockMatchesByTimestamp(GetMockMatchesByTimestamp input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelsGetMockTicketsResponse getAllMockTickets(GetAllMockTickets input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public List<ModelsMockTicket> createMockTickets(CreateMockTickets input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public void bulkCreateMockTickets(BulkCreateMockTickets input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        input.handleEmptyResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }

    public ModelsGetMockTicketsResponse getMockTicketsByTimestamp(GetMockTicketsByTimestamp input) throws Exception {
        if (input.getCustomBasePath().equals("") && !this.customBasePath.equals("")) {
            input.setCustomBasePath(this.customBasePath);
        }
        HttpResponse httpResponse = this.sdk.runRequest((Operation)input);
        return input.parseResponse(httpResponse.getCode(), httpResponse.getContentType(), httpResponse.getPayload());
    }
}

