/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.session.operations.party;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicPartyCancel
extends Operation {
    private String path = "/session/v1/public/namespaces/{namespace}/parties/{partyId}/users/{userId}/cancel";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String partyId;
    private String userId;

    @Deprecated
    public PublicPartyCancel(String customBasePath, String namespace, String partyId, String userId) {
        this.namespace = namespace;
        this.partyId = partyId;
        this.userId = userId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.partyId != null) {
            pathParams.put("partyId", this.partyId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.partyId == null) {
            return false;
        }
        return this.userId != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static PublicPartyCancelBuilder builder() {
        return new PublicPartyCancelBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class PublicPartyCancelBuilder {
        private String customBasePath;
        private String namespace;
        private String partyId;
        private String userId;

        PublicPartyCancelBuilder() {
        }

        public PublicPartyCancelBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicPartyCancelBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicPartyCancelBuilder partyId(String partyId) {
            this.partyId = partyId;
            return this;
        }

        public PublicPartyCancelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicPartyCancel build() {
            return new PublicPartyCancel(this.customBasePath, this.namespace, this.partyId, this.userId);
        }

        public String toString() {
            return "PublicPartyCancel.PublicPartyCancelBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", partyId=" + this.partyId + ", userId=" + this.userId + ")";
        }
    }
}

