/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.session.operations.session_storage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicUpdateInsertSessionStorage
extends Operation {
    private String path = "/session/v1/public/namespaces/{namespace}/sessions/{sessionId}/storage/users/{userId}";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String sessionId;
    private String userId;
    private Map<String, ?> body;

    @Deprecated
    public PublicUpdateInsertSessionStorage(String customBasePath, String namespace, String sessionId, String userId, Map<String, ?> body) {
        this.namespace = namespace;
        this.sessionId = sessionId;
        this.userId = userId;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.sessionId != null) {
            pathParams.put("sessionId", this.sessionId);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, ?> getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        if (this.sessionId == null) {
            return false;
        }
        return this.userId != null;
    }

    public Map<String, ?> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (Map)new ObjectMapper().readValue(json, new TypeReference<Map<String, ?>>(){});
    }

    public static PublicUpdateInsertSessionStorageBuilder builder() {
        return new PublicUpdateInsertSessionStorageBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Map<String, ?> getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(Map<String, ?> body) {
        this.body = body;
    }

    public static class PublicUpdateInsertSessionStorageBuilder {
        private String customBasePath;
        private String namespace;
        private String sessionId;
        private String userId;
        private Map<String, ?> body;

        PublicUpdateInsertSessionStorageBuilder() {
        }

        public PublicUpdateInsertSessionStorageBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicUpdateInsertSessionStorageBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicUpdateInsertSessionStorageBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public PublicUpdateInsertSessionStorageBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public PublicUpdateInsertSessionStorageBuilder body(Map<String, ?> body) {
            this.body = body;
            return this;
        }

        public PublicUpdateInsertSessionStorage build() {
            return new PublicUpdateInsertSessionStorage(this.customBasePath, this.namespace, this.sessionId, this.userId, this.body);
        }

        public String toString() {
            return "PublicUpdateInsertSessionStorage.PublicUpdateInsertSessionStorageBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", sessionId=" + this.sessionId + ", userId=" + this.userId + ", body=" + this.body + ")";
        }
    }
}

