/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.sessionhistory.operations.x_ray;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.sessionhistory.models.ApimodelsXRayMatchesQueryResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class QueryXrayMatch
extends Operation {
    private String path = "/sessionhistory/v2/admin/namespaces/{namespace}/xray/matches/{matchId}/tickets";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String matchId;
    private String namespace;

    @Deprecated
    public QueryXrayMatch(String customBasePath, String matchId, String namespace) {
        this.matchId = matchId;
        this.namespace = namespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.matchId != null) {
            pathParams.put("matchId", this.matchId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.matchId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ApimodelsXRayMatchesQueryResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ApimodelsXRayMatchesQueryResponse().createFromJson(json);
    }

    public static QueryXrayMatchBuilder builder() {
        return new QueryXrayMatchBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getMatchId() {
        return this.matchId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class QueryXrayMatchBuilder {
        private String customBasePath;
        private String matchId;
        private String namespace;

        QueryXrayMatchBuilder() {
        }

        public QueryXrayMatchBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public QueryXrayMatchBuilder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public QueryXrayMatchBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public QueryXrayMatch build() {
            return new QueryXrayMatch(this.customBasePath, this.matchId, this.namespace);
        }

        public String toString() {
            return "QueryXrayMatch.QueryXrayMatchBuilder(customBasePath=" + this.customBasePath + ", matchId=" + this.matchId + ", namespace=" + this.namespace + ")";
        }
    }
}

