/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.acesinc.data.json.generator.RandomJsonGenerator;
import net.acesinc.data.json.generator.log.EventLogger;
import net.acesinc.data.json.generator.workflow.Workflow;
import net.acesinc.data.json.generator.workflow.WorkflowStep;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventGenerator
implements Runnable {
    private static final Logger log = LogManager.getLogger(EventGenerator.class);
    private Workflow workflow;
    private String generatorName;
    private boolean running;
    private List<EventLogger> eventLoggers;
    private long startTime;
    private long generatedEvents = 0L;

    public EventGenerator(Workflow workflow, String generatorName, List<EventLogger> loggers) {
        this.workflow = workflow;
        this.generatorName = generatorName;
        this.eventLoggers = loggers;
    }

    public void runWorkflow() {
        String runMode = "sequential";
        if (this.workflow.getStepRunMode() != null) {
            runMode = this.workflow.getStepRunMode();
        }
        this.startTime = System.currentTimeMillis();
        switch (runMode) {
            case "sequential": {
                this.runSequential();
                break;
            }
            case "random": {
                this.runRandom();
                break;
            }
            case "random-pick-one": {
                this.runRandomPickOne();
                break;
            }
            default: {
                this.runSequential();
            }
        }
    }

    protected void runSequential() {
        Iterator<WorkflowStep> it = this.workflow.getSteps().iterator();
        while (this.running && it.hasNext()) {
            WorkflowStep step = it.next();
            this.executeStep(step);
            if (it.hasNext() || !this.workflow.isRepeatWorkflow()) continue;
            it = this.workflow.getSteps().iterator();
            try {
                this.performWorkflowSleep(this.workflow);
            }
            catch (InterruptedException ie) {
                this.running = false;
                break;
            }
        }
    }

    protected void runRandom() {
        ArrayList<WorkflowStep> stepsCopy = new ArrayList<WorkflowStep>(this.workflow.getSteps());
        Collections.shuffle(stepsCopy, new Random(System.currentTimeMillis()));
        Iterator it = stepsCopy.iterator();
        while (this.running && it.hasNext()) {
            WorkflowStep step = (WorkflowStep)it.next();
            this.executeStep(step);
            if (it.hasNext() || !this.workflow.isRepeatWorkflow()) continue;
            Collections.shuffle(stepsCopy, new Random(System.currentTimeMillis()));
            it = stepsCopy.iterator();
            try {
                this.performWorkflowSleep(this.workflow);
            }
            catch (InterruptedException ie) {
                this.running = false;
                break;
            }
        }
    }

    protected void runRandomPickOne() {
        while (this.running) {
            WorkflowStep step = this.workflow.getSteps().get(this.generateRandomNumber(0, this.workflow.getSteps().size() - 1));
            this.executeStep(step);
            if (!this.workflow.isRepeatWorkflow()) continue;
            try {
                this.performWorkflowSleep(this.workflow);
            }
            catch (InterruptedException ie) {
                this.running = false;
                break;
            }
        }
    }

    protected void executeStep(WorkflowStep step) {
        if (step.getDuration() == 0L) {
            for (Map<String, Object> config : step.getConfig()) {
                LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
                wrapper.put(null, config);
                try {
                    String event = this.generateEvent(wrapper);
                    for (EventLogger l : this.eventLoggers) {
                        l.logEvent(event, step.getProducerConfig());
                    }
                    try {
                        this.performEventSleep(this.workflow);
                    }
                    catch (InterruptedException ie) {
                        this.running = false;
                        break;
                    }
                }
                catch (IOException ioe) {
                    log.error("Error generating json event", (Throwable)ioe);
                }
            }
        } else if (step.getDuration() == -1L) {
            List<Map<String, Object>> configs = step.getConfig();
            while (this.running) {
                try {
                    LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
                    wrapper.put(null, configs.get(this.generateRandomNumber(0, configs.size() - 1)));
                    String event = this.generateEvent(wrapper);
                    for (EventLogger l : this.eventLoggers) {
                        l.logEvent(event, step.getProducerConfig());
                    }
                    try {
                        this.performEventSleep(this.workflow);
                    }
                    catch (InterruptedException ie) {
                        this.running = false;
                        break;
                    }
                }
                catch (IOException ioe) {
                    log.error("Error generating json event", (Throwable)ioe);
                }
            }
        } else {
            long now = new Date().getTime();
            long stopTime = now + step.getDuration();
            List<Map<String, Object>> configs = step.getConfig();
            while (new Date().getTime() < stopTime && this.running) {
                try {
                    LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
                    wrapper.put(null, configs.get(this.generateRandomNumber(0, configs.size() - 1)));
                    String event = this.generateEvent(wrapper);
                    for (EventLogger l : this.eventLoggers) {
                        l.logEvent(event, step.getProducerConfig());
                    }
                    try {
                        this.performEventSleep(this.workflow);
                    }
                    catch (InterruptedException ie) {
                        this.running = false;
                        break;
                    }
                }
                catch (IOException ioe) {
                    log.error("Error generating json event", (Throwable)ioe);
                }
            }
        }
        if (log.isTraceEnabled()) {
            ++this.generatedEvents;
            long elapsed = System.currentTimeMillis() - this.startTime;
            if (elapsed > 1000L) {
                double recordsPerSec = this.generatedEvents / (elapsed / 1000L);
                log.trace("Generator( " + this.generatorName + " ) generated " + recordsPerSec + " events/sec");
                this.startTime = System.currentTimeMillis();
                this.generatedEvents = 0L;
            }
        }
    }

    private void performEventSleep(Workflow workflow) throws InterruptedException {
        long durationBetweenEvents = workflow.getEventFrequency();
        if (workflow.isVaryEventFrequency()) {
            long minSleep = durationBetweenEvents - durationBetweenEvents / 2L;
            long maxSleep = durationBetweenEvents;
            Thread.sleep(this.generateRandomNumber(minSleep, maxSleep));
        } else {
            Thread.sleep(durationBetweenEvents);
        }
    }

    private void performWorkflowSleep(Workflow workflow) throws InterruptedException {
        if (workflow.getTimeBetweenRepeat() > 0L) {
            if (workflow.isVaryRepeatFrequency()) {
                long sleepDur = workflow.getTimeBetweenRepeat();
                long minSleep = sleepDur - sleepDur / 2L;
                long maxSleep = sleepDur;
                Thread.sleep(this.generateRandomNumber(minSleep, maxSleep));
            } else {
                Thread.sleep(workflow.getTimeBetweenRepeat());
            }
        }
    }

    public String generateEvent(Map<String, Object> config) throws IOException {
        RandomJsonGenerator generator = new RandomJsonGenerator(config);
        return generator.generateJson();
    }

    private int generateRandomNumber(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    private long generateRandomNumber(long min, long max) {
        return min + (long)(Math.random() * (double)(max - min + 1L));
    }

    @Override
    public void run() {
        try {
            this.setRunning(true);
            this.runWorkflow();
            this.setRunning(false);
        }
        catch (Throwable ie) {
            log.fatal("Exception occured causing the Generator to shutdown", ie);
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

