/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import net.acesinc.data.json.generator.SimulationRunner;
import net.acesinc.data.json.generator.config.JSONConfigReader;
import net.acesinc.data.json.generator.config.SimulationConfig;
import net.acesinc.data.json.generator.log.AzureIoTHubLogger;
import net.acesinc.data.json.generator.log.EventLogger;
import net.acesinc.data.json.generator.log.FileLogger;
import net.acesinc.data.json.generator.log.HttpPostLogger;
import net.acesinc.data.json.generator.log.KafkaLogger;
import net.acesinc.data.json.generator.log.Log4JLogger;
import net.acesinc.data.json.generator.log.MqttLogger;
import net.acesinc.data.json.generator.log.NatsLogger;
import net.acesinc.data.json.generator.log.TranquilityLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttException;

public class JsonDataGenerator {
    private static final Logger log = LogManager.getLogger(JsonDataGenerator.class);
    private SimulationRunner simRunner;
    private String simConfigFile;

    public JsonDataGenerator(String simConfigString) {
        this.simConfigFile = simConfigString;
        try {
            log.debug("Creating Simulation Runner using Simulation Config [ " + simConfigString + " ]");
            SimulationConfig simConfig = this.getSimConfig();
            ArrayList<EventLogger> loggers = new ArrayList<EventLogger>();
            for (Map<String, Object> elProps : simConfig.getProducers()) {
                String elType;
                switch (elType = (String)elProps.get("type")) {
                    case "logger": {
                        log.info("Adding Log4JLogger Producer");
                        loggers.add(new Log4JLogger());
                        break;
                    }
                    case "file": {
                        log.info("Adding File Logger with properties: " + elProps);
                        loggers.add(new FileLogger(elProps));
                        break;
                    }
                    case "kafka": {
                        log.info("Adding Kafka Producer with properties: " + elProps);
                        loggers.add(new KafkaLogger(elProps));
                        break;
                    }
                    case "tranquility": {
                        log.info("Adding Tranqulity Logger with properties: " + elProps);
                        loggers.add(new TranquilityLogger(elProps));
                        break;
                    }
                    case "nats": {
                        log.info("Adding NATS Logger with properties: " + elProps);
                        loggers.add(new NatsLogger(elProps));
                        break;
                    }
                    case "http-post": {
                        log.info("Adding HTTP Post Logger with properties: " + elProps);
                        try {
                            loggers.add(new HttpPostLogger(elProps));
                        }
                        catch (NoSuchAlgorithmException ex) {
                            log.error("http-post Logger unable to initialize", (Throwable)ex);
                        }
                        break;
                    }
                    case "mqtt": {
                        log.info("Adding MQTT Logger with properties: " + elProps);
                        try {
                            loggers.add(new MqttLogger(elProps));
                        }
                        catch (MqttException ex) {
                            log.error("mqtt Logger unable to initialize", (Throwable)ex);
                        }
                        break;
                    }
                    case "iothub": {
                        log.info("Adding Azure IoT Hub Logger with properties: " + elProps);
                        try {
                            loggers.add(new AzureIoTHubLogger(elProps));
                            break;
                        }
                        catch (URISyntaxException ex) {
                            log.error("Azure IoT Hub Logger unable to initialize", (Throwable)ex);
                        }
                    }
                }
            }
            if (loggers.isEmpty()) {
                throw new IllegalArgumentException("You must configure at least one Producer in the Simulation Config");
            }
            this.simRunner = new SimulationRunner(simConfig, loggers);
        }
        catch (IOException ex) {
            log.error("Error getting Simulation Config [ " + simConfigString + " ]", (Throwable)ex);
        }
    }

    public void startRunning() {
        this.simRunner.startSimulation();
    }

    public void stopRunning() {
        this.simRunner.stopSimulation();
    }

    private SimulationConfig getSimConfig() throws IOException {
        return JSONConfigReader.readConfig(this.getClass().getClassLoader().getResourceAsStream(this.simConfigFile), SimulationConfig.class);
    }

    public boolean isRunning() {
        return this.simRunner.isRunning();
    }

    public static void main(String[] args) {
        String simConfig = "defaultSimConfig.json";
        if (args.length > 0) {
            simConfig = args[0];
            log.info("Overriding Simulation Config file from command line to use [ " + simConfig + " ]");
        }
        final JsonDataGenerator gen = new JsonDataGenerator(simConfig);
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Shutdown Hook Invoked.  Shutting Down Loggers");
                gen.stopRunning();
                try {
                    mainThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        gen.startRunning();
        while (gen.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public String getSimConfigFile() {
        return this.simConfigFile;
    }

    public void setSimConfigFile(String simConfigFile) {
        this.simConfigFile = simConfigFile;
    }
}

