/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.acesinc.data.json.generator.RandomJsonGenerator;
import net.acesinc.data.json.generator.config.JSONConfigReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonGenerator {
    private static final Logger log = LogManager.getLogger(JsonGenerator.class);

    public Map<String, Object> testMapGenerator(String config) throws IOException {
        Map props = JSONConfigReader.readConfig(this.getClass().getClassLoader().getResourceAsStream(config), Map.class);
        LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
        wrapper.put(null, props);
        RandomJsonGenerator generator = new RandomJsonGenerator(wrapper);
        Map<String, Object> map = generator.generateJsonMap();
        return map;
    }

    public String testFlatJsonGenerator(String config) throws IOException {
        Map props = JSONConfigReader.readConfig(this.getClass().getClassLoader().getResourceAsStream(config), Map.class);
        LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
        wrapper.put(null, props);
        RandomJsonGenerator generator = new RandomJsonGenerator(wrapper);
        String json = generator.generateFlattnedJson();
        return json;
    }

    public List<Map<String, Object>> testListGenerator(String config) throws IOException {
        List props = JSONConfigReader.readConfig(this.getClass().getClassLoader().getResourceAsStream(config), List.class);
        LinkedHashMap<String, Object> wrapper = new LinkedHashMap<String, Object>();
        wrapper.put(null, props);
        RandomJsonGenerator generator = new RandomJsonGenerator(wrapper);
        List<Map<String, Object>> list = generator.generateJsonList();
        return list;
    }

    public static void main(String ... args) {
        String config = "config6.json";
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonGenerator gen = new JsonGenerator();
            log.info("Generated json Map: " + mapper.writeValueAsString(gen.testMapGenerator(config)));
            log.info("Generated flattened json Map: " + gen.testFlatJsonGenerator(config));
            JsonGenerator gen2 = new JsonGenerator();
            log.info("Generated json List: " + gen2.testListGenerator("config3.json"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

