/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import net.acesinc.data.json.generator.types.TypeHandler;
import net.acesinc.data.json.generator.types.TypeHandlerFactory;
import net.acesinc.data.json.util.JsonUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomJsonGenerator {
    private static final Logger log = LogManager.getLogger(RandomJsonGenerator.class);
    private SimpleDateFormat iso8601DF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private Map<String, Object> config;
    private static JsonGeneratorFactory factory = Json.createGeneratorFactory(null);
    private Map<String, Object> generatedValues;
    private JsonUtils jsonUtils;

    public RandomJsonGenerator(Map<String, Object> config) {
        this.config = config;
        this.jsonUtils = new JsonUtils();
    }

    public String generateJson() {
        StringWriter w = new StringWriter();
        JsonGenerator gen = factory.createGenerator((Writer)w);
        this.generatedValues = new LinkedHashMap<String, Object>();
        this.processProperties(gen, this.config, "");
        gen.flush();
        return w.toString();
    }

    public String generateFlattnedJson() throws IOException {
        String json = this.generateJson();
        return this.jsonUtils.flattenJson(json);
    }

    public Map<String, Object> generateJsonMap() throws IOException {
        String json = this.generateJson();
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(json, Map.class);
    }

    public List<Map<String, Object>> generateJsonList() throws IOException {
        String json = this.generateJson();
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.readValue(json, List.class);
    }

    private JsonGenerator processProperties(JsonGenerator gen, Map<String, Object> props, String currentContext) {
        for (String propName : props.keySet()) {
            Object value;
            block27: {
                block28: {
                    List listOfItems;
                    String newContext;
                    block29: {
                        value = props.get(propName);
                        if (value == null) {
                            this.generatedValues.put(currentContext + propName, null);
                            this.addValue(gen, propName, null);
                            continue;
                        }
                        if (String.class.isAssignableFrom(value.getClass())) {
                            String type = (String)value;
                            if (type.startsWith("this.") || type.startsWith("cur.")) {
                                String refPropName = null;
                                if (type.startsWith("this.")) {
                                    refPropName = type.substring("this.".length(), type.length());
                                } else if (type.startsWith("cur.")) {
                                    refPropName = currentContext + type.substring("cur.".length(), type.length());
                                }
                                Object refPropValue = this.generatedValues.get(refPropName);
                                if (refPropValue != null) {
                                    this.addValue(gen, propName, refPropValue);
                                    continue;
                                }
                                log.warn("Sorry, unable to reference property [ " + refPropName + " ]. Maybe it hasn't been generated yet?");
                                continue;
                            }
                            try {
                                TypeHandler th = TypeHandlerFactory.getInstance().getTypeHandler(type, this.generatedValues, currentContext);
                                if (th != null) {
                                    Object val = th.getNextRandomValue();
                                    this.generatedValues.put(currentContext + propName, val);
                                    this.addValue(gen, propName, val);
                                    continue;
                                }
                                this.generatedValues.put(currentContext + propName, type);
                                this.addValue(gen, propName, type);
                            }
                            catch (IllegalArgumentException iae) {
                                log.warn("Error creating type [ " + type + " ]. Prop [ " + propName + " ] being ignored in output.  Reason: " + iae.getMessage());
                                log.debug("Error creating type [ " + type + " ]. Prop [ " + propName + " ] being ignored in output.", (Throwable)iae);
                            }
                            continue;
                        }
                        if (Map.class.isAssignableFrom(value.getClass())) {
                            Map nestedProps = (Map)value;
                            if (propName == null) {
                                gen.writeStartObject();
                            } else {
                                gen.writeStartObject(propName);
                            }
                            newContext = "";
                            if (propName != null) {
                                newContext = currentContext.isEmpty() ? propName + "." : currentContext + propName + ".";
                            }
                            this.processProperties(gen, nestedProps, newContext);
                            gen.writeEnd();
                            continue;
                        }
                        if (!List.class.isAssignableFrom(value.getClass())) break block27;
                        listOfItems = (List)value;
                        newContext = "";
                        if (propName != null) {
                            gen.writeStartArray(propName);
                            newContext = currentContext.isEmpty() ? propName : currentContext + propName;
                        } else {
                            gen.writeStartArray();
                        }
                        if (listOfItems.isEmpty()) break block28;
                        if (!String.class.isAssignableFrom(listOfItems.get(0).getClass()) || !((String)listOfItems.get(0)).contains("(")) break block29;
                        String name = (String)listOfItems.get(0);
                        String specialFunc = null;
                        String[] specialFuncArgs = new String[]{};
                        specialFunc = name.substring(0, name.indexOf("("));
                        String args = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                        if (!args.isEmpty()) {
                            specialFuncArgs = args.split(",");
                        }
                        switch (specialFunc) {
                            case "repeat": {
                                int timesToRepeat = 1;
                                timesToRepeat = specialFuncArgs.length == 1 ? Integer.parseInt(specialFuncArgs[0]) : new RandomDataGenerator().nextInt(0, 10);
                                List<Object> subList = listOfItems.subList(1, listOfItems.size());
                                for (int i = 0; i < timesToRepeat; ++i) {
                                    this.processList(subList, gen, newContext);
                                }
                                break block28;
                            }
                            case "random": {
                                List subList = listOfItems.subList(1, listOfItems.size());
                                Object item = subList.get(new RandomDataGenerator().nextInt(0, subList.size() - 1));
                                this.processItem(item, gen, newContext + "[0]");
                                break;
                            }
                        }
                        break block28;
                    }
                    this.processList(listOfItems, gen, newContext);
                }
                gen.writeEnd();
                continue;
            }
            this.generatedValues.put(currentContext + propName, value);
            this.addValue(gen, propName, value);
        }
        return gen;
    }

    protected void processList(List<Object> listOfItems, JsonGenerator gen, String currentContext) {
        for (int i = 0; i < listOfItems.size(); ++i) {
            Object item = listOfItems.get(i);
            String newContext = currentContext + "[" + i + "]";
            this.processItem(item, gen, newContext);
        }
    }

    protected void processItem(Object item, JsonGenerator gen, String currentContext) {
        if (String.class.isAssignableFrom(item.getClass())) {
            this.addValue(gen, null, (String)item);
            this.generatedValues.put(currentContext, (String)item);
        } else if (Map.class.isAssignableFrom(item.getClass())) {
            Map nestedProps = (Map)item;
            gen.writeStartObject();
            this.processProperties(gen, nestedProps, currentContext + ".");
            gen.writeEnd();
        }
    }

    private JsonGenerator addValue(JsonGenerator gen, String propName, Object val) {
        if (val == null) {
            gen.writeNull(propName);
        } else if (String.class.isAssignableFrom(val.getClass())) {
            if (propName != null) {
                gen.write(propName, (String)val);
            } else {
                gen.write((String)val);
            }
        } else if (Boolean.class.isAssignableFrom(val.getClass())) {
            gen.write(propName, ((Boolean)val).booleanValue());
        } else if (Long.class.isAssignableFrom(val.getClass())) {
            gen.write(propName, ((Long)val).longValue());
        } else if (Integer.class.isAssignableFrom(val.getClass())) {
            gen.write(propName, ((Integer)val).intValue());
        } else if (Double.class.isAssignableFrom(val.getClass())) {
            gen.write(propName, ((Double)val).doubleValue());
        } else if (Date.class.isAssignableFrom(val.getClass())) {
            gen.write(propName, this.iso8601DF.format((Date)val));
        }
        return gen;
    }
}

