/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.log;

import com.microsoft.azure.sdk.iot.device.DeviceClient;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.Message;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import net.acesinc.data.json.generator.log.EventLogger;

public final class AzureIoTHubLogger
implements EventLogger {
    private final DeviceClient deviceClient;

    public AzureIoTHubLogger(Map<String, Object> props) throws URISyntaxException, IOException {
        this.deviceClient = new DeviceClient((String)props.get("connectionString"), IotHubClientProtocol.valueOf((String)((String)props.get("protocol"))));
        this.deviceClient.open();
    }

    public AzureIoTHubLogger(DeviceClient deviceClient) {
        this.deviceClient = deviceClient;
    }

    @Override
    public void logEvent(String event, Map<String, Object> producerConfig) {
        this.deviceClient.sendEventAsync(new Message(event), null, null);
    }

    @Override
    public void shutdown() {
        if (this.deviceClient != null) {
            try {
                this.deviceClient.closeNow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

