/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.log;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.acesinc.data.json.generator.log.EventLogger;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileLogger
implements EventLogger {
    private static final Logger log = LogManager.getLogger(FileLogger.class);
    public static final String OUTPUT_DIRECTORY_PROP_NAME = "output.directory";
    public static final String FILE_PREFIX_PROP_NAME = "file.prefix";
    public static final String FILE_EXTENSION_PROP_NAME = "file.extension";
    private File outputDirectory;
    private String filePrefix;
    private String fileExtension;

    public FileLogger(Map<String, Object> props) throws IOException {
        String outputDir = (String)props.get(OUTPUT_DIRECTORY_PROP_NAME);
        this.outputDirectory = new File(outputDir);
        if (!(this.outputDirectory.exists() || this.outputDirectory.mkdir() || this.outputDirectory.mkdirs())) {
            throw new IOException("Output directory does not exist and we are unable to create it");
        }
        this.filePrefix = (String)props.get(FILE_PREFIX_PROP_NAME);
        this.fileExtension = (String)props.get(FILE_EXTENSION_PROP_NAME);
    }

    @Override
    public void logEvent(String event, Map<String, Object> producerConfig) {
        this.logEvent(event);
    }

    private void logEvent(String event) {
        try {
            File f = File.createTempFile(this.filePrefix, this.fileExtension, this.outputDirectory);
            FileUtils.writeStringToFile((File)f, (String)event, (String)"UTF-8");
        }
        catch (IOException ioe) {
            log.error("Unable to create temp file");
        }
    }

    @Override
    public void shutdown() {
    }
}

