/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.log;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.acesinc.data.json.generator.log.EventLogger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpPostLogger
implements EventLogger {
    private static final Logger log = LogManager.getLogger(HttpPostLogger.class);
    public static final String URL_PROP_NAME = "url";
    private String url;
    private CloseableHttpClient httpClient;

    public HttpPostLogger(Map<String, Object> props) throws NoSuchAlgorithmException {
        this.url = (String)props.get(URL_PROP_NAME);
        SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(SSLContext.getDefault(), (HostnameVerifier)new NoopHostnameVerifier());
        this.httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sf).build();
    }

    @Override
    public void logEvent(String event, Map<String, Object> producerConfig) {
        this.logEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEvent(String event) {
        block16: {
            try {
                HttpPost request = new HttpPost(this.url);
                StringEntity input = new StringEntity(event);
                input.setContentType("application/json");
                request.setEntity((HttpEntity)input);
                CloseableHttpResponse response = null;
                try {
                    response = this.httpClient.execute((HttpUriRequest)request);
                }
                catch (IOException ex) {
                    log.error("Error POSTing Event", (Throwable)ex);
                }
                if (response == null) break block16;
                try {
                    HttpEntity resEntity = response.getEntity();
                    if (resEntity != null) {
                        // empty if block
                    }
                    EntityUtils.consume((HttpEntity)resEntity);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        response.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

