/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.log;

import java.util.Map;
import net.acesinc.data.json.generator.log.EventLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttLogger
implements EventLogger {
    private static final Logger log = LogManager.getLogger(MqttLogger.class);
    private static final String PRODUCER_TYPE_NAME = "mqtt";
    private static final String BROKER_SERVER_PROP_NAME = "broker.server";
    private static final String BROKER_PORT_PROP_NAME = "broker.port";
    private static final String TOPIC_PROP_NAME = "topic";
    private static final String CLIENT_ID_PROP_NAME = "clientId";
    private static final String QOS_PROP_NAME = "qos";
    private static final String USERNAME_PROP_NAME = "username";
    private static final String PASSWORD_PROP_NAME = "password";
    private static final String DEFAULT_CLIENT_ID = "JsonGenerator";
    private static final int DEFAULT_QOS = 2;
    private final MqttClient mqttClient;
    private final String topic;
    private final int qos;

    public MqttLogger(Map<String, Object> props) throws MqttException {
        String brokerHost = (String)props.get(BROKER_SERVER_PROP_NAME);
        Integer brokerPort = (Integer)props.get(BROKER_PORT_PROP_NAME);
        String brokerAddress = brokerHost + ":" + brokerPort.toString();
        String clientId = (String)props.get(CLIENT_ID_PROP_NAME);
        String username = (String)props.get(USERNAME_PROP_NAME);
        String password = (String)props.get(PASSWORD_PROP_NAME);
        this.topic = (String)props.get(TOPIC_PROP_NAME);
        Integer _qos = (Integer)props.get(QOS_PROP_NAME);
        this.qos = null == _qos ? 2 : _qos;
        this.mqttClient = new MqttClient(brokerAddress, null == clientId ? DEFAULT_CLIENT_ID : clientId);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        if (null != username) {
            connOpts.setUserName(username);
            if (null != password) {
                connOpts.setPassword(password.toCharArray());
            }
        }
        log.debug("Connecting to broker: " + brokerAddress);
        this.mqttClient.connect(connOpts);
        log.debug("Connected");
    }

    @Override
    public void logEvent(String event, Map<String, Object> producerConfig) {
        String _topic = null;
        Integer _qos = null;
        Object value = producerConfig.get(PRODUCER_TYPE_NAME);
        if (null != value && Map.class.isAssignableFrom(value.getClass())) {
            Map config = (Map)value;
            _topic = (String)config.get(TOPIC_PROP_NAME);
            _qos = (Integer)config.get(QOS_PROP_NAME);
        }
        this.logEvent(event, null == _topic ? this.topic : _topic, null == _qos ? this.qos : _qos);
    }

    private void logEvent(String event, String topic, int qos) {
        MqttMessage message = new MqttMessage(event.getBytes());
        message.setQos(qos);
        try {
            this.mqttClient.publish(topic, message);
            log.debug("Message published");
        }
        catch (MqttException ex) {
            log.error("Failed to publish message", (Throwable)ex);
        }
    }

    @Override
    public void shutdown() {
        if (null != this.mqttClient) {
            try {
                this.mqttClient.disconnect();
                System.out.println("Disconnected");
            }
            catch (MqttException ex) {
                log.error("Error in disconnect", (Throwable)ex);
            }
        }
    }
}

