/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import net.acesinc.data.json.generator.types.NowBaseType;
import net.acesinc.data.json.generator.types.TypeHandler;

public abstract class BaseDateType
extends TypeHandler {
    private Date min;
    private Date max;
    public static final ThreadLocal<DateFormat> INPUT_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss");
        }
    };

    @Override
    public void setLaunchArguments(String[] launchArguments) {
        block11: {
            super.setLaunchArguments(launchArguments);
            try {
                long timeOffset;
                if (launchArguments.length == 0) {
                    this.min = INPUT_DATE_FORMAT.get().parse("1970/01/01T00:00:00");
                    this.max = new Date();
                    break block11;
                }
                if (launchArguments.length == 1) {
                    try {
                        this.min = INPUT_DATE_FORMAT.get().parse(BaseDateType.stripQuotes(launchArguments[0]));
                    }
                    catch (ParseException pe) {
                        long timeOffset2 = NowBaseType.getTimeOffset(BaseDateType.stripQuotes(launchArguments[0]));
                        this.min = new Date(new Date().getTime() + timeOffset2);
                    }
                    this.max = new Date();
                    break block11;
                }
                if (launchArguments.length != 2) break block11;
                try {
                    this.min = INPUT_DATE_FORMAT.get().parse(BaseDateType.stripQuotes(launchArguments[0]));
                }
                catch (ParseException pe) {
                    timeOffset = NowBaseType.getTimeOffset(BaseDateType.stripQuotes(launchArguments[0]));
                    this.min = new Date(new Date().getTime() + timeOffset);
                }
                try {
                    this.max = INPUT_DATE_FORMAT.get().parse(BaseDateType.stripQuotes(launchArguments[1]));
                }
                catch (ParseException pe) {
                    timeOffset = NowBaseType.getTimeOffset(BaseDateType.stripQuotes(launchArguments[1]));
                    this.max = new Date(new Date().getTime() + timeOffset);
                }
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Provided date is invalid. Please use the format [ yyyy/MM/dd ]", ex);
            }
        }
        if (!this.min.before(this.max) && !this.min.equals(this.max)) {
            throw new IllegalArgumentException("Min Date must be before Max Date");
        }
    }

    public Date getRandomDate() {
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendar minCal = new GregorianCalendar();
        minCal.setTime(this.min);
        GregorianCalendar maxCal = new GregorianCalendar();
        maxCal.setTime(this.max);
        int year = this.getRand().nextInt(minCal.get(1), maxCal.get(1));
        gc.set(1, year);
        int month = -1;
        month = minCal.get(1) == maxCal.get(1) ? this.getRand().nextInt(minCal.get(2), maxCal.get(2)) : (year == minCal.get(1) ? this.getRand().nextInt(minCal.get(2), gc.getActualMaximum(2)) : (year == maxCal.get(1) ? this.getRand().nextInt(gc.getActualMinimum(2), maxCal.get(2)) : this.getRand().nextInt(gc.getActualMinimum(2), gc.getActualMaximum(2))));
        gc.set(2, month);
        int day = -1;
        day = minCal.get(1) == maxCal.get(1) && minCal.get(2) == maxCal.get(2) ? this.getRand().nextInt(minCal.get(5), maxCal.get(5)) : (year == minCal.get(1) && month == minCal.get(2) ? this.getRand().nextInt(minCal.get(5), gc.getActualMaximum(5)) : (year == maxCal.get(1) && month == maxCal.get(2) ? this.getRand().nextInt(gc.getActualMinimum(5), maxCal.get(5)) : this.getRand().nextInt(1, gc.getActualMaximum(5))));
        gc.set(5, day);
        int minHour = gc.getActualMinimum(11);
        int minMin = gc.getActualMinimum(12);
        int minSec = gc.getActualMinimum(13);
        int maxHour = gc.getActualMaximum(11);
        int maxMin = gc.getActualMaximum(12);
        int maxSec = gc.getActualMaximum(13);
        if (minCal.get(1) == gc.get(1) && minCal.get(2) == gc.get(2) && minCal.get(5) == gc.get(5)) {
            minHour = minCal.get(11);
        }
        if (maxCal.get(1) == gc.get(1) && maxCal.get(2) == gc.get(2) && maxCal.get(5) == gc.get(5)) {
            maxHour = maxCal.get(11);
        }
        int hour = this.getRand().nextInt(minHour, maxHour);
        gc.set(11, hour);
        if (minHour == maxHour) {
            minMin = minCal.get(12);
            maxMin = maxCal.get(12);
        } else if (hour == minHour) {
            minMin = minCal.get(12);
        } else if (hour == maxHour) {
            maxMin = maxCal.get(12);
        }
        int minute = this.getRand().nextInt(minMin, maxMin);
        gc.set(12, minute);
        if (minHour == maxHour && minMin == maxMin) {
            minSec = minCal.get(13);
            maxSec = maxCal.get(13);
        } else if (hour == minHour && minute == minMin) {
            minSec = minCal.get(13);
        } else if (hour == maxHour && minute == maxMin) {
            maxSec = maxCal.get(13);
        }
        int sec = this.getRand().nextInt(minSec, maxSec);
        gc.set(13, sec);
        gc.set(14, 0);
        return gc.getTime();
    }
}

