/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import java.util.Random;
import net.acesinc.data.json.generator.types.TypeHandler;
import org.apache.commons.math3.util.Precision;

public class DoubleType
extends TypeHandler {
    public static final String TYPE_NAME = "double";
    public static final String TYPE_DISPLAY_NAME = "Double";
    private double min;
    private double max;
    private Random rand = new Random();
    private static final int decimalPlaces = 4;

    @Override
    public void setLaunchArguments(String[] launchArguments) {
        super.setLaunchArguments(launchArguments);
        if (launchArguments.length == 0) {
            this.min = 0.0;
            this.max = Double.MAX_VALUE;
        } else if (launchArguments.length == 1) {
            this.min = Double.parseDouble(launchArguments[0]);
            this.max = Double.MAX_VALUE;
        } else if (launchArguments.length == 2) {
            this.min = Double.parseDouble(launchArguments[0]);
            this.max = Double.parseDouble(launchArguments[1]);
        }
    }

    @Override
    public Double getNextRandomValue() {
        double range = this.max - this.min;
        double scaled = this.rand.nextDouble() * range;
        double shifted = scaled + this.min;
        return Precision.round((double)shifted, (int)4);
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }
}

