/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import net.acesinc.data.json.generator.types.TypeHandler;

public class LongType
extends TypeHandler {
    public static final String TYPE_NAME = "long";
    public static final String TYPE_DISPLAY_NAME = "Long";
    private long min;
    private long max;

    @Override
    public void setLaunchArguments(String[] launchArguments) {
        super.setLaunchArguments(launchArguments);
        if (launchArguments.length == 0) {
            this.min = 0L;
            this.max = Long.MAX_VALUE;
        } else if (launchArguments.length == 1) {
            this.min = Long.parseLong(launchArguments[0]);
            this.max = Long.MAX_VALUE;
        } else if (launchArguments.length == 2) {
            this.min = Long.parseLong(launchArguments[0]);
            this.max = Long.parseLong(launchArguments[1]);
        }
    }

    @Override
    public Long getNextRandomValue() {
        return this.getRand().nextLong(this.min, this.max);
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }
}

