/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import java.util.Date;
import net.acesinc.data.json.generator.types.TypeHandler;

public abstract class NowBaseType
extends TypeHandler {
    private long timeToAdd = 0L;

    @Override
    public void setLaunchArguments(String[] launchArguments) {
        super.setLaunchArguments(launchArguments);
        this.timeToAdd = launchArguments.length == 0 ? 0L : NowBaseType.getTimeOffset(launchArguments[0]);
    }

    public static long getTimeOffset(String input) {
        String arg;
        long timeOffset = 0L;
        String timeAmount = arg = NowBaseType.stripQuotes(input);
        boolean isNegative = false;
        if (arg.startsWith("-")) {
            isNegative = true;
            timeAmount = arg.substring(1, arg.length());
        }
        String[] pieces = timeAmount.split("_");
        int time = Integer.parseInt(pieces[0]);
        String unit = pieces[1];
        long multiplier = 1L;
        switch (unit) {
            case "y": {
                multiplier = 1471228928L;
                break;
            }
            case "d": {
                multiplier = 86400000L;
                break;
            }
            case "h": {
                multiplier = 3600000L;
                break;
            }
            case "m": {
                multiplier = 60000L;
            }
        }
        timeOffset = (long)time * multiplier;
        if (isNegative) {
            timeOffset *= -1L;
        }
        return timeOffset;
    }

    public Date getNextDate() {
        if (this.timeToAdd == 0L) {
            return new Date();
        }
        return new Date(new Date().getTime() + this.timeToAdd);
    }
}

