/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import java.util.HashMap;
import java.util.Map;
import net.acesinc.data.json.generator.types.TypeHandler;

public class RandomIncrementLongType
extends TypeHandler {
    public static final String TYPE_NAME = "randomIncrementLong";
    public static final String TYPE_DISPLAY_NAME = "Random Increment Long";
    private String currentRandomIncrementLongName;
    private final Map<String, IncrementParameters> namedRandomIncrementLongMap = new HashMap<String, IncrementParameters>();

    @Override
    public void setLaunchArguments(String[] launchArguments) {
        long maxStep;
        long minStep;
        long nextValue;
        if (launchArguments.length < 1) {
            throw new IllegalArgumentException("Arguments list is too short");
        }
        this.currentRandomIncrementLongName = launchArguments[0];
        if (this.namedRandomIncrementLongMap.get(this.currentRandomIncrementLongName) != null) {
            return;
        }
        super.setLaunchArguments(launchArguments);
        switch (launchArguments.length) {
            case 1: {
                nextValue = 0L;
                minStep = 0L;
                maxStep = Long.MAX_VALUE;
                break;
            }
            case 2: {
                nextValue = Long.parseLong(launchArguments[1]);
                minStep = 0L;
                maxStep = Long.MAX_VALUE;
                break;
            }
            case 3: {
                nextValue = Long.parseLong(launchArguments[1]);
                minStep = Long.parseLong(launchArguments[2]);
                maxStep = Long.MAX_VALUE;
                break;
            }
            case 4: {
                nextValue = Long.parseLong(launchArguments[1]);
                minStep = Long.parseLong(launchArguments[2]);
                maxStep = Long.parseLong(launchArguments[3]);
                break;
            }
            default: {
                return;
            }
        }
        this.namedRandomIncrementLongMap.put(this.currentRandomIncrementLongName, new IncrementParameters(nextValue, minStep, maxStep));
    }

    @Override
    public Object getNextRandomValue() {
        IncrementParameters incrementParameters = this.namedRandomIncrementLongMap.get(this.currentRandomIncrementLongName);
        long value = incrementParameters.nextValue;
        incrementParameters.nextValue += this.getRand().nextLong(incrementParameters.minStep, incrementParameters.maxStep);
        return value;
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    private class IncrementParameters {
        public long nextValue;
        public final long minStep;
        public final long maxStep;

        public IncrementParameters(long nextValue, long minStep, long maxStep) {
            this.nextValue = nextValue;
            this.minStep = minStep;
            this.maxStep = maxStep;
        }
    }
}

