/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import java.util.ArrayList;
import java.util.List;
import net.acesinc.data.json.generator.types.TypeHandler;

public class RandomType
extends TypeHandler {
    public static final String TYPE_NAME = "random";
    public static final String TYPE_DISPLAY_NAME = "Random";
    private List<Object> typedValues;

    @Override
    public void setLaunchArguments(String[] launchArguments) {
        super.setLaunchArguments(launchArguments);
        this.typedValues = new ArrayList<Object>();
        for (String s : launchArguments) {
            try {
                if (s.contains("\"") || s.contains("'")) {
                    this.typedValues.add(RandomType.stripQuotes(s));
                    continue;
                }
                if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
                    this.typedValues.add(Boolean.parseBoolean(s));
                    continue;
                }
                if (s.contains(".")) {
                    this.typedValues.add(Double.parseDouble(s));
                    continue;
                }
                this.typedValues.add(Long.parseLong(s));
            }
            catch (Throwable t) {
                this.typedValues.add(RandomType.stripQuotes(s));
            }
        }
    }

    @Override
    public Object getNextRandomValue() {
        return this.typedValues.get(this.getRand().nextInt(0, this.typedValues.size() - 1));
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }
}

