/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.acesinc.data.json.generator.types.BaseDateType;
import net.acesinc.data.json.generator.types.TypeHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class TypeHandlerFactory {
    private static final Logger log = LogManager.getLogger(TypeHandlerFactory.class);
    private static TypeHandlerFactory instance;
    private Map<String, Class> typeHandlerNameMap = new LinkedHashMap<String, Class>();
    private Map<String, TypeHandler> typeHandlerCache = new LinkedHashMap<String, TypeHandler>();
    private static final ThreadLocal<TypeHandlerFactory> localInstance;

    private TypeHandlerFactory() {
        this.scanForTypeHandlers();
    }

    public static TypeHandlerFactory getInstance() {
        return localInstance.get();
    }

    private void scanForTypeHandlers() {
        Reflections reflections = new Reflections("net.acesinc.data.json.generator.types", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(TypeHandler.class);
        for (Class type : subTypes) {
            if (Modifier.isAbstract(type.getModifiers())) continue;
            try {
                Object o = type.newInstance();
                Method nameMethod = o.getClass().getMethod("getName", new Class[0]);
                nameMethod.setAccessible(true);
                String typeHandlerName = (String)nameMethod.invoke(o, new Object[0]);
                this.typeHandlerNameMap.put(typeHandlerName, type);
                log.debug("Discovered TypeHandler [ " + typeHandlerName + "," + type.getName() + " ]");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                log.warn("Error instantiating TypeHandler class [ " + type.getName() + " ]. It will not be available during processing.", (Throwable)ex);
            }
        }
    }

    public TypeHandler getTypeHandler(String name, Map<String, Object> knownValues, String currentContext) throws IllegalArgumentException {
        if (name.contains("(")) {
            String typeName = name.substring(0, name.indexOf("("));
            String args = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
            String[] helperArgs = new String[]{};
            if (!args.isEmpty()) {
                helperArgs = args.split(",");
                helperArgs = TypeHandlerFactory.prepareStrings(helperArgs);
            }
            ArrayList<String> resolvedArgs = new ArrayList<String>();
            for (String arg : helperArgs) {
                if (arg.startsWith("this.") || arg.startsWith("cur.")) {
                    String refPropName = null;
                    if (arg.startsWith("this.")) {
                        refPropName = arg.substring("this.".length(), arg.length());
                    } else if (arg.startsWith("cur.")) {
                        refPropName = currentContext + arg.substring("cur.".length(), arg.length());
                    }
                    Object refPropValue = knownValues.get(refPropName);
                    if (refPropValue != null) {
                        if (Date.class.isAssignableFrom(refPropValue.getClass())) {
                            resolvedArgs.add(BaseDateType.INPUT_DATE_FORMAT.get().format((Date)refPropValue));
                            continue;
                        }
                        resolvedArgs.add(refPropValue.toString());
                        continue;
                    }
                    log.warn("Sorry, unable to reference property [ " + refPropName + " ]. Maybe it hasn't been generated yet?");
                    continue;
                }
                resolvedArgs.add(arg);
            }
            TypeHandler handler = this.typeHandlerCache.get(typeName);
            if (handler == null) {
                Class handlerClass = this.typeHandlerNameMap.get(typeName);
                if (handlerClass != null) {
                    try {
                        handler = (TypeHandler)handlerClass.newInstance();
                        handler.setLaunchArguments(resolvedArgs.toArray(new String[0]));
                        this.typeHandlerCache.put(typeName, handler);
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        log.warn("Error instantiating TypeHandler class [ " + handlerClass.getName() + " ]", (Throwable)ex);
                    }
                }
            } else {
                handler.setLaunchArguments(resolvedArgs.toArray(new String[0]));
            }
            return handler;
        }
        return null;
    }

    public static String[] prepareStrings(String[] list) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String item : list) {
            newList.add(item.trim());
        }
        return newList.toArray(new String[0]);
    }

    public static void main(String[] args) {
        LinkedHashMap<String, Object> vals = new LinkedHashMap<String, Object>();
        TypeHandler random = TypeHandlerFactory.getInstance().getTypeHandler("random('one', 'two', 'three')", vals, "");
        if (random == null) {
            log.error("error getting handler");
        } else {
            log.info("success! random value: " + random.getNextRandomValue());
        }
    }

    static {
        localInstance = new ThreadLocal<TypeHandlerFactory>(){

            @Override
            protected TypeHandlerFactory initialValue() {
                return new TypeHandlerFactory();
            }
        };
    }
}

