/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.generator.workflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.acesinc.data.json.generator.workflow.WorkflowStep;

public class Workflow {
    private List<WorkflowStep> steps = new ArrayList<WorkflowStep>();
    private long eventFrequency;
    private boolean varyEventFrequency;
    private boolean repeatWorkflow;
    private long timeBetweenRepeat;
    private boolean varyRepeatFrequency;
    private String stepRunMode;

    public boolean equals(Object obj) {
        if (obj instanceof Workflow) {
            Workflow w = (Workflow)obj;
            if (w.getEventFrequency() != this.eventFrequency) {
                return false;
            }
            if (w.isVaryEventFrequency() != this.varyEventFrequency) {
                return false;
            }
            if (!w.getStepRunMode().equals(this.stepRunMode)) {
                return false;
            }
            List<WorkflowStep> compSteps = w.getSteps();
            if (compSteps.size() != this.steps.size()) {
                return false;
            }
            for (int i = 0; i < compSteps.size(); ++i) {
                WorkflowStep s = this.steps.get(i);
                WorkflowStep compS = compSteps.get(i);
                if (s.getDuration() != compS.getDuration()) {
                    return false;
                }
                List<Map<String, Object>> configs = s.getConfig();
                List<Map<String, Object>> compConfigs = compS.getConfig();
                if (configs.size() != compConfigs.size()) {
                    return false;
                }
                for (int j = 0; j < compConfigs.size(); ++j) {
                    HashSet<Object> values2;
                    HashSet<String> keys2;
                    Map<String, Object> config = configs.get(j);
                    Map<String, Object> compConfig = compConfigs.get(j);
                    if (config.size() != compConfig.size()) {
                        return false;
                    }
                    HashSet<String> keys1 = new HashSet<String>(config.keySet());
                    if (!keys1.equals(keys2 = new HashSet<String>(compConfig.keySet()))) {
                        return false;
                    }
                    HashSet<Object> values1 = new HashSet<Object>(config.values());
                    if (values1.equals(values2 = new HashSet<Object>(compConfig.values()))) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public void addStep(WorkflowStep step) {
        this.getSteps().add(step);
    }

    public List<WorkflowStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<WorkflowStep> steps) {
        this.steps = steps;
    }

    public long getEventFrequency() {
        return this.eventFrequency;
    }

    public void setEventFrequency(long eventFrequency) {
        this.eventFrequency = eventFrequency;
    }

    public boolean isVaryEventFrequency() {
        return this.varyEventFrequency;
    }

    public void setVaryEventFrequency(boolean varyEventFrequency) {
        this.varyEventFrequency = varyEventFrequency;
    }

    public boolean isRepeatWorkflow() {
        return this.repeatWorkflow;
    }

    public void setRepeatWorkflow(boolean repeatWorkflow) {
        this.repeatWorkflow = repeatWorkflow;
    }

    public long getTimeBetweenRepeat() {
        return this.timeBetweenRepeat;
    }

    public void setTimeBetweenRepeat(long timeBetweenRepeat) {
        this.timeBetweenRepeat = timeBetweenRepeat;
    }

    public boolean isVaryRepeatFrequency() {
        return this.varyRepeatFrequency;
    }

    public void setVaryRepeatFrequency(boolean varyRepeatFrequency) {
        this.varyRepeatFrequency = varyRepeatFrequency;
    }

    public String getStepRunMode() {
        return this.stepRunMode;
    }

    public void setStepRunMode(String stepRunMode) {
        this.stepRunMode = stepRunMode;
    }
}

