/*
 * Decompiled with CFR 0.152.
 */
package net.acesinc.data.json.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonUtils {
    private ObjectMapper mapper = new ObjectMapper();

    public String flattenJson(String json) throws IOException {
        LinkedHashMap<String, Object> outputMap = new LinkedHashMap<String, Object>();
        this.flattenJsonIntoMap("", this.mapper.readTree(json), outputMap);
        return this.mapper.writeValueAsString(outputMap);
    }

    public void flattenJsonIntoMap(String currentPath, JsonNode jsonNode, Map<String, Object> map) {
        if (jsonNode.isObject()) {
            String pathPrefix;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iter = objectNode.fields();
            String string = pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.flattenJsonIntoMap(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue(), map);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.flattenJsonIntoMap(currentPath + "[" + i + "]", arrayNode.get(i), map);
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            Object value = null;
            if (valueNode.isNumber()) {
                value = valueNode.numberValue();
            } else if (valueNode.isBoolean()) {
                value = valueNode.asBoolean();
            } else if (valueNode.isTextual()) {
                value = valueNode.asText();
            }
            map.put(currentPath, value);
        }
    }
}

