/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.testutil;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Properties;
import javax.crypto.KeyAgreement;
import net.adamcin.commons.testing.junit.FailUtil;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyTestUtil.class);
    private static final String BOUNCY_CASTLE = "BC";
    public static final String P_TYPE = "type";
    public static final String TYPE_RSA = "ssh-rsa";
    public static final String TYPE_DSA = "ssh-dss";
    public static final String DSA_P = "p";
    public static final String DSA_Q = "q";
    public static final String DSA_G = "g";
    public static final String DSA_Y = "y";
    public static final String DSA_X = "x";
    public static final String RSA_N = "n";
    public static final String RSA_E = "e";
    public static final String RSA_D = "d";
    public static final String RSA_P = "p";
    public static final String RSA_Q = "q";
    public static final String RSA_PE = "pe";
    public static final String RSA_QE = "qe";
    public static final String RSA_U = "u";
    private static final File TEST_TEMP;
    protected static final char[] hexArray;

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static InputStream getAuthorizedKeysStream() {
        return KeyTestUtil.class.getResourceAsStream("/authorized_keys");
    }

    public static File getAuthorizedKeysFile() {
        return KeyTestUtil.getResourceAsFile("/authorized_keys");
    }

    public static File getPrivateKeyAsFile(String parentName, String keyName) {
        return KeyTestUtil.getResourceAsFile("/" + parentName + "/" + keyName);
    }

    public static byte[] dumpKeyBlob(PublicKey publicKey) {
        ByteArrayOutputStream byteOs;
        block4: {
            byteOs = new ByteArrayOutputStream();
            try {
                if (publicKey instanceof RSAPublicKey) {
                    RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                    DataOutputStream dos = new DataOutputStream(byteOs);
                    dos.writeInt(TYPE_RSA.getBytes().length);
                    dos.write(TYPE_RSA.getBytes());
                    dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
                    dos.write(rsaPublicKey.getPublicExponent().toByteArray());
                    dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
                    dos.write(rsaPublicKey.getModulus().toByteArray());
                    break block4;
                }
                if (publicKey instanceof DSAPublicKey) {
                    DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
                    DSAParams dsaParams = dsaPublicKey.getParams();
                    DataOutputStream dos = new DataOutputStream(byteOs);
                    dos.writeInt(TYPE_DSA.getBytes().length);
                    dos.write(TYPE_DSA.getBytes());
                    dos.writeInt(dsaParams.getP().toByteArray().length);
                    dos.write(dsaParams.getP().toByteArray());
                    dos.writeInt(dsaParams.getQ().toByteArray().length);
                    dos.write(dsaParams.getQ().toByteArray());
                    dos.writeInt(dsaParams.getG().toByteArray().length);
                    dos.write(dsaParams.getG().toByteArray());
                    dos.writeInt(dsaPublicKey.getY().toByteArray().length);
                    dos.write(dsaPublicKey.getY().toByteArray());
                    break block4;
                }
                throw new IllegalArgumentException("Not a supported public key: " + publicKey);
            }
            catch (IOException e) {
                LOGGER.error("failed to dump public key blob", (Throwable)e);
            }
        }
        return byteOs.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyPair getKeyPairFromProperties(String parentName, String keyName) {
        InputStream is = null;
        try {
            is = KeyTestUtil.class.getResourceAsStream("/" + parentName + "/" + keyName + ".properties");
            Properties props = new Properties();
            props.load(is);
            if (TYPE_RSA.equals(props.getProperty(P_TYPE))) {
                RSAPrivateKeySpec privSpec = null;
                privSpec = props.getProperty("p") != null && props.getProperty("q") != null && props.getProperty(RSA_U) != null ? new RSAPrivateCrtKeySpec(new BigInteger(props.getProperty(RSA_N)), new BigInteger(props.getProperty(RSA_E)), new BigInteger(props.getProperty(RSA_D)), new BigInteger(props.getProperty("p")), new BigInteger(props.getProperty("q")), new BigInteger(props.getProperty(RSA_PE)), new BigInteger(props.getProperty(RSA_QE)), new BigInteger(props.getProperty(RSA_U))) : new RSAPrivateKeySpec(new BigInteger(props.getProperty(RSA_N)), new BigInteger(props.getProperty(RSA_D)));
                RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(new BigInteger(props.getProperty(RSA_N)), new BigInteger(props.getProperty(RSA_E)));
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                KeyPair keyPair = new KeyPair(keyFactory.generatePublic(pubSpec), keyFactory.generatePrivate(privSpec));
                IOUtils.closeQuietly((InputStream)is);
                return keyPair;
            }
            if (TYPE_DSA.equals(props.getProperty(P_TYPE))) {
                DSAPrivateKeySpec privSpec = new DSAPrivateKeySpec(new BigInteger(props.getProperty(DSA_X)), new BigInteger(props.getProperty("p")), new BigInteger(props.getProperty("q")), new BigInteger(props.getProperty(DSA_G)));
                DSAPublicKeySpec pubSpec = new DSAPublicKeySpec(new BigInteger(props.getProperty(DSA_Y)), new BigInteger(props.getProperty("p")), new BigInteger(props.getProperty("q")), new BigInteger(props.getProperty(DSA_G)));
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                KeyPair keyPair = new KeyPair(keyFactory.generatePublic(pubSpec), keyFactory.generatePrivate(privSpec));
                IOUtils.closeQuietly((InputStream)is);
                return keyPair;
            }
            IOUtils.closeQuietly((InputStream)is);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read properties", (Throwable)e);
            return null;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair getPrivateKeyAsKeyPair(String parentName, String keyName, String passphrase) {
        PEMParser parser;
        FileInputStream is;
        block6: {
            KeyPair keyPair;
            Object o;
            JcaPEMKeyConverter converter;
            block5: {
                converter = new JcaPEMKeyConverter();
                File privateKeyFile = KeyTestUtil.getPrivateKeyAsFile(parentName, keyName);
                is = null;
                parser = null;
                is = new FileInputStream(privateKeyFile);
                parser = new PEMParser((Reader)new InputStreamReader(is));
                o = parser.readObject();
                if (!(o instanceof PEMEncryptedKeyPair)) break block5;
                PEMEncryptedKeyPair _encPair = (PEMEncryptedKeyPair)o;
                PEMDecryptorProvider decryptionProv = new JcePEMDecryptorProviderBuilder().build(passphrase.toCharArray());
                KeyPair keyPair2 = converter.getKeyPair(_encPair.decryptKeyPair(decryptionProv));
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((Reader)parser);
                return keyPair2;
            }
            try {
                if (!(o instanceof PEMKeyPair)) break block6;
                keyPair = converter.getKeyPair((PEMKeyPair)o);
            }
            catch (Exception e) {
                try {
                    LOGGER.error("failed to parse private key file: parent=" + parentName + " keyName=" + keyName, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(parser);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((Reader)parser);
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((Reader)parser);
            return keyPair;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)parser);
        return null;
    }

    public static File getPublicKeyAsFile(String parentName, String keyName) {
        return KeyTestUtil.getResourceAsFile("/" + parentName + "/" + keyName + ".pub");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getResourceAsFile(String name) {
        File file;
        File temp = new File(TEST_TEMP, name.substring(1));
        if (temp.exists()) {
            return temp;
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = KeyTestUtil.class.getResourceAsStream(name);
            os = new FileOutputStream(temp);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            file = temp;
        }
        catch (IOException e) {
            try {
                FailUtil.sprintFail((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
            return null;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        return file;
    }

    static {
        try {
            if (Security.getProvider(BOUNCY_CASTLE) == null) {
                LOGGER.info("Trying to register BouncyCastle as a JCE provider");
                Security.addProvider((Provider)new BouncyCastleProvider());
                MessageDigest.getInstance("MD5", BOUNCY_CASTLE);
                KeyAgreement.getInstance("DH", BOUNCY_CASTLE);
                LOGGER.info("Registration succeeded");
            } else {
                LOGGER.info("BouncyCastle already registered ");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register bouncycastle provider", (Throwable)e);
        }
        TEST_TEMP = new File("target/test-temp");
        TEST_TEMP.mkdirs();
        new File(TEST_TEMP, "b1024").mkdirs();
        new File(TEST_TEMP, "b2048").mkdirs();
        new File(TEST_TEMP, "b4096").mkdirs();
        new File(TEST_TEMP, "withpass").mkdirs();
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

