/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.vltpack;

import java.io.File;
import net.adamcin.vltpack.OutputParameters;
import net.adamcin.vltpack.VltpackUtil$;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalax.io.Codec;
import scalax.io.Resource$;
import scalax.io.managed.SeekableByteChannelResource;

public abstract class OutputParameters$class {
    public static File outputDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.project().getBuild().getDirectory()));
    }

    public static File targetFile(OutputParameters $this) {
        return new File($this.outputDirectory(), new StringBuilder().append((Object)$this.project().getBuild().getFinalName()).append((Object)".zip").toString());
    }

    public static File vltpackDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.outputDirectory(), "vltpack"));
    }

    public static File embedBundlesDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vltpackDirectory(), "embed-bundles"));
    }

    public static String relativeToBundleInstallPath(OutputParameters $this, File bundle) {
        return VltpackUtil$.MODULE$.toRelative($this.embedBundlesDirectory(), bundle.getPath());
    }

    public static File embedPackagesDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vltpackDirectory(), "embed-packages"));
    }

    public static File packageDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vltpackDirectory(), "package"));
    }

    public static File packageSha(OutputParameters $this) {
        return new File($this.packageDirectory(), "package.sha1");
    }

    public static File uploadDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vltpackDirectory(), "IT-upload"));
    }

    public static File uploadSha(OutputParameters $this) {
        return new File($this.uploadDirectory(), "IT-upload.sha1");
    }

    public static File uploadTestsDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vltpackDirectory(), "IT-upload-tests"));
    }

    public static File uploadTestsSha(OutputParameters $this) {
        return new File($this.uploadTestsDirectory(), "IT-upload-tests.sha1");
    }

    public static File vaultInfDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vltpackDirectory(), "vault-inf"));
    }

    public static File transientRepoDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vaultInfDirectory(), "definitionRepo"));
    }

    public static File vaultInfMetaInfDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vaultInfDirectory(), "META-INF"));
    }

    public static File configSha(OutputParameters $this) {
        return new File($this.vaultInfDirectory(), "config.sha1");
    }

    public static File filterSha(OutputParameters $this) {
        return new File($this.vaultInfDirectory(), "filter.sha1");
    }

    public static File propertiesSha(OutputParameters $this) {
        return new File($this.vaultInfDirectory(), "properties.sha1");
    }

    public static File definitionSha(OutputParameters $this) {
        return new File($this.vaultInfDirectory(), "definition.sha1");
    }

    public static File vaultDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vaultInfMetaInfDirectory(), "vault"));
    }

    public static File configXml(OutputParameters $this) {
        return new File($this.vaultDirectory(), "config.xml");
    }

    public static File settingsXml(OutputParameters $this) {
        return new File($this.vaultDirectory(), "settings.xml");
    }

    public static File filterXml(OutputParameters $this) {
        return new File($this.vaultDirectory(), "filter.xml");
    }

    public static File propertiesXml(OutputParameters $this) {
        return new File($this.vaultDirectory(), "properties.xml");
    }

    public static File definitionDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vaultDirectory(), "definition"));
    }

    public static File definitionXml(OutputParameters $this) {
        return new File($this.definitionDirectory(), ".content.xml");
    }

    public static File thumbnailDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.definitionDirectory(), "thumbnail"));
    }

    public static File thumbnailFileDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.thumbnailDirectory(), "file"));
    }

    public static File thumbnailFileXml(OutputParameters $this) {
        return $this.getExistingDir(new File($this.thumbnailFileDirectory(), ".content.xml"));
    }

    public static File hooksDirectory(OutputParameters $this) {
        return $this.getExistingDir(new File($this.vaultDirectory(), "hooks"));
    }

    public static File getExistingDir(OutputParameters $this, File file) {
        if (!file.exists() && !file.mkdir()) {
            $this.net$adamcin$vltpack$OutputParameters$$log().error("[getExistingDir] failed to create directory: {}", (Object)file);
        }
        return file;
    }

    public static Stream listFiles(OutputParameters $this, File file) {
        return file.isDirectory() ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OutputParameters $outer;

            public final Stream<File> apply(File x$1) {
                return this.$outer.listFiles(x$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).toStream() : package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file}));
    }

    public static boolean inputFileModified(OutputParameters $this, File output, List inputFiles) {
        return $this.inputFileModified(output, (Stream<File>)inputFiles.toStream());
    }

    public static boolean inputFileModified(OutputParameters $this, File output, Stream inputFiles) {
        return !output.exists() || inputFiles.exists((Function1)new Serializable($this, output){
            public static final long serialVersionUID = 0L;
            private final File output$1;

            public final boolean apply(File file) {
                Option option;
                block4: {
                    boolean bl;
                    block3: {
                        Some x2;
                        block2: {
                            option = Option$.MODULE$.apply((Object)file);
                            None$ none$ = None$.MODULE$;
                            Option option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                            Option x3 = option;
                            bl = false;
                            break block3;
                        }
                        if (!(option instanceof Some) || (x2 = (Some)option) == null) break block4;
                        File f = (File)x2.x();
                        bl = !file.exists() || file.lastModified() >= this.output$1.lastModified();
                    }
                    return bl;
                }
                throw new MatchError((Object)option);
            }
            {
                this.output$1 = output$1;
            }
        });
    }

    public static void overwriteFile(OutputParameters $this, File file, String content) {
        Object object = file.exists() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
        SeekableByteChannelResource qual$1 = Resource$.MODULE$.fromFile(file);
        String x$2 = content;
        Codec x$3 = qual$1.write$default$2(x$2);
        qual$1.write(x$2, x$3);
    }

    public static void $init$(OutputParameters $this) {
        $this.net$adamcin$vltpack$OutputParameters$_setter_$net$adamcin$vltpack$OutputParameters$$log_$eq(LoggerFactory.getLogger($this.getClass()));
    }
}

