/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3Architecture;
import net.adoptopenjdk.v3.api.AOV3BinaryType;
import net.adoptopenjdk.v3.api.AOV3HeapSize;
import net.adoptopenjdk.v3.api.AOV3ImageKind;
import net.adoptopenjdk.v3.api.AOV3Installer;
import net.adoptopenjdk.v3.api.AOV3JVMImplementation;
import net.adoptopenjdk.v3.api.AOV3OperatingSystem;
import net.adoptopenjdk.v3.api.AOV3PackageType;

public final class AOV3Binary
implements AOV3BinaryType {
    private final AOV3Architecture architecture;
    private final BigInteger downloadCount;
    private final AOV3HeapSize heapSize;
    private final AOV3ImageKind imageType;
    private final AOV3Installer installer;
    private final AOV3JVMImplementation jvmImplementation;
    private final AOV3OperatingSystem operatingSystem;
    private final AOV3PackageType package_;
    private final String project;
    private final String scmReference;
    private final OffsetDateTime updatedAt;

    private AOV3Binary(AOV3Architecture architecture, BigInteger downloadCount, AOV3HeapSize heapSize, AOV3ImageKind imageType, AOV3Installer installer, AOV3JVMImplementation jvmImplementation, AOV3OperatingSystem operatingSystem, AOV3PackageType package_, String project, String scmReference, OffsetDateTime updatedAt) {
        this.architecture = architecture;
        this.downloadCount = downloadCount;
        this.heapSize = heapSize;
        this.imageType = imageType;
        this.installer = installer;
        this.jvmImplementation = jvmImplementation;
        this.operatingSystem = operatingSystem;
        this.package_ = package_;
        this.project = project;
        this.scmReference = scmReference;
        this.updatedAt = updatedAt;
    }

    @Override
    public AOV3Architecture architecture() {
        return this.architecture;
    }

    @Override
    public BigInteger downloadCount() {
        return this.downloadCount;
    }

    @Override
    public AOV3HeapSize heapSize() {
        return this.heapSize;
    }

    @Override
    public AOV3ImageKind imageType() {
        return this.imageType;
    }

    @Override
    public Optional<AOV3Installer> installer() {
        return Optional.ofNullable(this.installer);
    }

    @Override
    public AOV3JVMImplementation jvmImplementation() {
        return this.jvmImplementation;
    }

    @Override
    public AOV3OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public AOV3PackageType package_() {
        return this.package_;
    }

    @Override
    public String project() {
        return this.project;
    }

    @Override
    public Optional<String> scmReference() {
        return Optional.ofNullable(this.scmReference);
    }

    @Override
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public final AOV3Binary withArchitecture(AOV3Architecture value) {
        if (this.architecture == value) {
            return this;
        }
        AOV3Architecture newValue = Objects.requireNonNull(value, "architecture");
        if (this.architecture.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(newValue, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withDownloadCount(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "downloadCount");
        if (this.downloadCount.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, newValue, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withHeapSize(AOV3HeapSize value) {
        if (this.heapSize == value) {
            return this;
        }
        AOV3HeapSize newValue = Objects.requireNonNull(value, "heapSize");
        if (this.heapSize.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, newValue, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withImageType(AOV3ImageKind value) {
        if (this.imageType == value) {
            return this;
        }
        AOV3ImageKind newValue = Objects.requireNonNull(value, "imageType");
        if (this.imageType.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, newValue, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withInstaller(AOV3Installer value) {
        AOV3Installer newValue = Objects.requireNonNull(value, "installer");
        if (this.installer == newValue) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, newValue, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withInstaller(Optional<? extends AOV3Installer> optional) {
        AOV3Installer value = optional.orElse(null);
        if (this.installer == value) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, value, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withJvmImplementation(AOV3JVMImplementation value) {
        if (this.jvmImplementation == value) {
            return this;
        }
        AOV3JVMImplementation newValue = Objects.requireNonNull(value, "jvmImplementation");
        if (this.jvmImplementation.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, newValue, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withOperatingSystem(AOV3OperatingSystem value) {
        if (this.operatingSystem == value) {
            return this;
        }
        AOV3OperatingSystem newValue = Objects.requireNonNull(value, "operatingSystem");
        if (this.operatingSystem.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, newValue, this.package_, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withPackage_(AOV3PackageType value) {
        if (this.package_ == value) {
            return this;
        }
        AOV3PackageType newValue = Objects.requireNonNull(value, "package_");
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, newValue, this.project, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withProject(String value) {
        String newValue = Objects.requireNonNull(value, "project");
        if (this.project.equals(newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, newValue, this.scmReference, this.updatedAt);
    }

    public final AOV3Binary withScmReference(String value) {
        String newValue = Objects.requireNonNull(value, "scmReference");
        if (Objects.equals(this.scmReference, newValue)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, newValue, this.updatedAt);
    }

    public final AOV3Binary withScmReference(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.scmReference, value)) {
            return this;
        }
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, value, this.updatedAt);
    }

    public final AOV3Binary withUpdatedAt(OffsetDateTime value) {
        if (this.updatedAt == value) {
            return this;
        }
        OffsetDateTime newValue = Objects.requireNonNull(value, "updatedAt");
        return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3Binary && this.equalTo((AOV3Binary)another);
    }

    private boolean equalTo(AOV3Binary another) {
        return this.architecture.equals(another.architecture) && this.downloadCount.equals(another.downloadCount) && this.heapSize.equals(another.heapSize) && this.imageType.equals(another.imageType) && Objects.equals(this.installer, another.installer) && this.jvmImplementation.equals(another.jvmImplementation) && this.operatingSystem.equals(another.operatingSystem) && this.package_.equals(another.package_) && this.project.equals(another.project) && Objects.equals(this.scmReference, another.scmReference) && this.updatedAt.equals(another.updatedAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.architecture.hashCode();
        h += (h << 5) + this.downloadCount.hashCode();
        h += (h << 5) + this.heapSize.hashCode();
        h += (h << 5) + this.imageType.hashCode();
        h += (h << 5) + Objects.hashCode(this.installer);
        h += (h << 5) + this.jvmImplementation.hashCode();
        h += (h << 5) + this.operatingSystem.hashCode();
        h += (h << 5) + this.package_.hashCode();
        h += (h << 5) + this.project.hashCode();
        h += (h << 5) + Objects.hashCode(this.scmReference);
        h += (h << 5) + this.updatedAt.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AOV3Binary{");
        builder.append("architecture=").append(this.architecture);
        builder.append(", ");
        builder.append("downloadCount=").append(this.downloadCount);
        builder.append(", ");
        builder.append("heapSize=").append(this.heapSize);
        builder.append(", ");
        builder.append("imageType=").append(this.imageType);
        if (this.installer != null) {
            builder.append(", ");
            builder.append("installer=").append(this.installer);
        }
        builder.append(", ");
        builder.append("jvmImplementation=").append(this.jvmImplementation);
        builder.append(", ");
        builder.append("operatingSystem=").append(this.operatingSystem);
        builder.append(", ");
        builder.append("package_=").append(this.package_);
        builder.append(", ");
        builder.append("project=").append(this.project);
        if (this.scmReference != null) {
            builder.append(", ");
            builder.append("scmReference=").append(this.scmReference);
        }
        builder.append(", ");
        builder.append("updatedAt=").append(this.updatedAt);
        return builder.append("}").toString();
    }

    public static AOV3Binary copyOf(AOV3BinaryType instance) {
        if (instance instanceof AOV3Binary) {
            return (AOV3Binary)instance;
        }
        return AOV3Binary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ARCHITECTURE = 1L;
        private static final long INIT_BIT_DOWNLOAD_COUNT = 2L;
        private static final long INIT_BIT_HEAP_SIZE = 4L;
        private static final long INIT_BIT_IMAGE_TYPE = 8L;
        private static final long INIT_BIT_JVM_IMPLEMENTATION = 16L;
        private static final long INIT_BIT_OPERATING_SYSTEM = 32L;
        private static final long INIT_BIT_PACKAGE_ = 64L;
        private static final long INIT_BIT_PROJECT = 128L;
        private static final long INIT_BIT_UPDATED_AT = 256L;
        private long initBits = 511L;
        private AOV3Architecture architecture;
        private BigInteger downloadCount;
        private AOV3HeapSize heapSize;
        private AOV3ImageKind imageType;
        private AOV3Installer installer;
        private AOV3JVMImplementation jvmImplementation;
        private AOV3OperatingSystem operatingSystem;
        private AOV3PackageType package_;
        private String project;
        private String scmReference;
        private OffsetDateTime updatedAt;

        private Builder() {
        }

        public final Builder from(AOV3BinaryType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setArchitecture(instance.architecture());
            this.setDownloadCount(instance.downloadCount());
            this.setHeapSize(instance.heapSize());
            this.setImageType(instance.imageType());
            Optional<AOV3Installer> installerOptional = instance.installer();
            if (installerOptional.isPresent()) {
                this.setInstaller(installerOptional);
            }
            this.setJvmImplementation(instance.jvmImplementation());
            this.setOperatingSystem(instance.operatingSystem());
            this.setPackage_(instance.package_());
            this.setProject(instance.project());
            Optional<String> scmReferenceOptional = instance.scmReference();
            if (scmReferenceOptional.isPresent()) {
                this.setScmReference(scmReferenceOptional);
            }
            this.setUpdatedAt(instance.updatedAt());
            return this;
        }

        public final Builder setArchitecture(AOV3Architecture architecture) {
            this.architecture = Objects.requireNonNull(architecture, "architecture");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDownloadCount(BigInteger downloadCount) {
            this.downloadCount = Objects.requireNonNull(downloadCount, "downloadCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setHeapSize(AOV3HeapSize heapSize) {
            this.heapSize = Objects.requireNonNull(heapSize, "heapSize");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setImageType(AOV3ImageKind imageType) {
            this.imageType = Objects.requireNonNull(imageType, "imageType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setInstaller(AOV3Installer installer) {
            this.installer = Objects.requireNonNull(installer, "installer");
            return this;
        }

        public final Builder setInstaller(Optional<? extends AOV3Installer> installer) {
            this.installer = installer.orElse(null);
            return this;
        }

        public final Builder setJvmImplementation(AOV3JVMImplementation jvmImplementation) {
            this.jvmImplementation = Objects.requireNonNull(jvmImplementation, "jvmImplementation");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setOperatingSystem(AOV3OperatingSystem operatingSystem) {
            this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setPackage_(AOV3PackageType package_) {
            this.package_ = Objects.requireNonNull(package_, "package_");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setProject(String project) {
            this.project = Objects.requireNonNull(project, "project");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setScmReference(String scmReference) {
            this.scmReference = Objects.requireNonNull(scmReference, "scmReference");
            return this;
        }

        public final Builder setScmReference(Optional<String> scmReference) {
            this.scmReference = scmReference.orElse(null);
            return this;
        }

        public final Builder setUpdatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public AOV3Binary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3Binary(this.architecture, this.downloadCount, this.heapSize, this.imageType, this.installer, this.jvmImplementation, this.operatingSystem, this.package_, this.project, this.scmReference, this.updatedAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("architecture");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("downloadCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("heapSize");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("imageType");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("jvmImplementation");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("operatingSystem");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("package_");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build AOV3Binary, some of required attributes are not set " + attributes;
        }
    }
}

