/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3HasNameTextType;

public enum AOV3OperatingSystem implements AOV3HasNameTextType
{
    AIX("aix"),
    LINUX("linux"),
    MAC("mac"),
    SOLARIS("solaris"),
    WINDOWS("windows");

    private final String nameText;

    private AOV3OperatingSystem(String name) {
        this.nameText = Objects.requireNonNull(name, "name");
    }

    public static AOV3OperatingSystem of(String operatingSystem) {
        return AOV3OperatingSystem.valueOf(operatingSystem.toUpperCase());
    }

    @Override
    public String nameText() {
        return this.nameText;
    }
}

