/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3BinaryType;
import net.adoptopenjdk.v3.api.AOV3ReleaseKind;
import net.adoptopenjdk.v3.api.AOV3ReleaseType;
import net.adoptopenjdk.v3.api.AOV3Source;
import net.adoptopenjdk.v3.api.AOV3Vendor;
import net.adoptopenjdk.v3.api.AOV3VersionData;

public final class AOV3Release
implements AOV3ReleaseType {
    private final List<AOV3BinaryType> binaries;
    private final BigInteger downloadCount;
    private final String id;
    private final URI releaseLink;
    private final String releaseName;
    private final AOV3ReleaseKind releaseType;
    private final AOV3Source source;
    private final OffsetDateTime timestamp;
    private final OffsetDateTime updatedAt;
    private final AOV3Vendor vendor;
    private final AOV3VersionData versionData;

    private AOV3Release(List<AOV3BinaryType> binaries, BigInteger downloadCount, String id, URI releaseLink, String releaseName, AOV3ReleaseKind releaseType, AOV3Source source, OffsetDateTime timestamp, OffsetDateTime updatedAt, AOV3Vendor vendor, AOV3VersionData versionData) {
        this.binaries = binaries;
        this.downloadCount = downloadCount;
        this.id = id;
        this.releaseLink = releaseLink;
        this.releaseName = releaseName;
        this.releaseType = releaseType;
        this.source = source;
        this.timestamp = timestamp;
        this.updatedAt = updatedAt;
        this.vendor = vendor;
        this.versionData = versionData;
    }

    @Override
    public List<AOV3BinaryType> binaries() {
        return this.binaries;
    }

    @Override
    public BigInteger downloadCount() {
        return this.downloadCount;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public URI releaseLink() {
        return this.releaseLink;
    }

    @Override
    public String releaseName() {
        return this.releaseName;
    }

    @Override
    public AOV3ReleaseKind releaseType() {
        return this.releaseType;
    }

    @Override
    public Optional<AOV3Source> source() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    @Override
    public AOV3Vendor vendor() {
        return this.vendor;
    }

    @Override
    public AOV3VersionData versionData() {
        return this.versionData;
    }

    public final AOV3Release withBinaries(AOV3BinaryType ... elements) {
        List<AOV3BinaryType> newValue = AOV3Release.createUnmodifiableList(false, AOV3Release.createSafeList(Arrays.asList(elements), true, false));
        return new AOV3Release(newValue, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withBinaries(Iterable<? extends AOV3BinaryType> elements) {
        if (this.binaries == elements) {
            return this;
        }
        List<AOV3BinaryType> newValue = AOV3Release.createUnmodifiableList(false, AOV3Release.createSafeList(elements, true, false));
        return new AOV3Release(newValue, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withDownloadCount(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "downloadCount");
        if (this.downloadCount.equals(newValue)) {
            return this;
        }
        return new AOV3Release(this.binaries, newValue, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new AOV3Release(this.binaries, this.downloadCount, newValue, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withReleaseLink(URI value) {
        if (this.releaseLink == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "releaseLink");
        return new AOV3Release(this.binaries, this.downloadCount, this.id, newValue, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withReleaseName(String value) {
        String newValue = Objects.requireNonNull(value, "releaseName");
        if (this.releaseName.equals(newValue)) {
            return this;
        }
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, newValue, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withReleaseType(AOV3ReleaseKind value) {
        if (this.releaseType == value) {
            return this;
        }
        AOV3ReleaseKind newValue = Objects.requireNonNull(value, "releaseType");
        if (this.releaseType.equals(newValue)) {
            return this;
        }
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, newValue, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withSource(AOV3Source value) {
        AOV3Source newValue = Objects.requireNonNull(value, "source");
        if (this.source == newValue) {
            return this;
        }
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, newValue, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withSource(Optional<? extends AOV3Source> optional) {
        AOV3Source value = optional.orElse(null);
        if (this.source == value) {
            return this;
        }
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, value, this.timestamp, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withTimestamp(OffsetDateTime value) {
        if (this.timestamp == value) {
            return this;
        }
        OffsetDateTime newValue = Objects.requireNonNull(value, "timestamp");
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, newValue, this.updatedAt, this.vendor, this.versionData);
    }

    public final AOV3Release withUpdatedAt(OffsetDateTime value) {
        if (this.updatedAt == value) {
            return this;
        }
        OffsetDateTime newValue = Objects.requireNonNull(value, "updatedAt");
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, newValue, this.vendor, this.versionData);
    }

    public final AOV3Release withVendor(AOV3Vendor value) {
        if (this.vendor == value) {
            return this;
        }
        AOV3Vendor newValue = Objects.requireNonNull(value, "vendor");
        if (this.vendor.equals(newValue)) {
            return this;
        }
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, newValue, this.versionData);
    }

    public final AOV3Release withVersionData(AOV3VersionData value) {
        if (this.versionData == value) {
            return this;
        }
        AOV3VersionData newValue = Objects.requireNonNull(value, "versionData");
        return new AOV3Release(this.binaries, this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3Release && this.equalTo((AOV3Release)another);
    }

    private boolean equalTo(AOV3Release another) {
        return this.binaries.equals(another.binaries) && this.downloadCount.equals(another.downloadCount) && this.id.equals(another.id) && this.releaseLink.equals(another.releaseLink) && this.releaseName.equals(another.releaseName) && this.releaseType.equals(another.releaseType) && Objects.equals(this.source, another.source) && this.timestamp.equals(another.timestamp) && this.updatedAt.equals(another.updatedAt) && this.vendor.equals(another.vendor) && this.versionData.equals(another.versionData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.binaries.hashCode();
        h += (h << 5) + this.downloadCount.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.releaseLink.hashCode();
        h += (h << 5) + this.releaseName.hashCode();
        h += (h << 5) + this.releaseType.hashCode();
        h += (h << 5) + Objects.hashCode(this.source);
        h += (h << 5) + this.timestamp.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.vendor.hashCode();
        h += (h << 5) + this.versionData.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AOV3Release{");
        builder.append("binaries=").append(this.binaries);
        builder.append(", ");
        builder.append("downloadCount=").append(this.downloadCount);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("releaseLink=").append(this.releaseLink);
        builder.append(", ");
        builder.append("releaseName=").append(this.releaseName);
        builder.append(", ");
        builder.append("releaseType=").append(this.releaseType);
        if (this.source != null) {
            builder.append(", ");
            builder.append("source=").append(this.source);
        }
        builder.append(", ");
        builder.append("timestamp=").append(this.timestamp);
        builder.append(", ");
        builder.append("updatedAt=").append(this.updatedAt);
        builder.append(", ");
        builder.append("vendor=").append(this.vendor);
        builder.append(", ");
        builder.append("versionData=").append(this.versionData);
        return builder.append("}").toString();
    }

    public static AOV3Release copyOf(AOV3ReleaseType instance) {
        if (instance instanceof AOV3Release) {
            return (AOV3Release)instance;
        }
        return AOV3Release.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DOWNLOAD_COUNT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_RELEASE_LINK = 4L;
        private static final long INIT_BIT_RELEASE_NAME = 8L;
        private static final long INIT_BIT_RELEASE_TYPE = 16L;
        private static final long INIT_BIT_TIMESTAMP = 32L;
        private static final long INIT_BIT_UPDATED_AT = 64L;
        private static final long INIT_BIT_VENDOR = 128L;
        private static final long INIT_BIT_VERSION_DATA = 256L;
        private long initBits = 511L;
        private List<AOV3BinaryType> binaries = new ArrayList<AOV3BinaryType>();
        private BigInteger downloadCount;
        private String id;
        private URI releaseLink;
        private String releaseName;
        private AOV3ReleaseKind releaseType;
        private AOV3Source source;
        private OffsetDateTime timestamp;
        private OffsetDateTime updatedAt;
        private AOV3Vendor vendor;
        private AOV3VersionData versionData;

        private Builder() {
        }

        public final Builder from(AOV3ReleaseType instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllBinaries(instance.binaries());
            this.setDownloadCount(instance.downloadCount());
            this.setId(instance.id());
            this.setReleaseLink(instance.releaseLink());
            this.setReleaseName(instance.releaseName());
            this.setReleaseType(instance.releaseType());
            Optional<AOV3Source> sourceOptional = instance.source();
            if (sourceOptional.isPresent()) {
                this.setSource(sourceOptional);
            }
            this.setTimestamp(instance.timestamp());
            this.setUpdatedAt(instance.updatedAt());
            this.setVendor(instance.vendor());
            this.setVersionData(instance.versionData());
            return this;
        }

        public final Builder addBinaries(AOV3BinaryType element) {
            this.binaries.add(Objects.requireNonNull(element, "binaries element"));
            return this;
        }

        public final Builder addBinaries(AOV3BinaryType ... elements) {
            for (AOV3BinaryType element : elements) {
                this.binaries.add(Objects.requireNonNull(element, "binaries element"));
            }
            return this;
        }

        public final Builder setBinaries(Iterable<? extends AOV3BinaryType> elements) {
            this.binaries.clear();
            return this.addAllBinaries(elements);
        }

        public final Builder addAllBinaries(Iterable<? extends AOV3BinaryType> elements) {
            for (AOV3BinaryType aOV3BinaryType : elements) {
                this.binaries.add(Objects.requireNonNull(aOV3BinaryType, "binaries element"));
            }
            return this;
        }

        public final Builder setDownloadCount(BigInteger downloadCount) {
            this.downloadCount = Objects.requireNonNull(downloadCount, "downloadCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setReleaseLink(URI releaseLink) {
            this.releaseLink = Objects.requireNonNull(releaseLink, "releaseLink");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setReleaseName(String releaseName) {
            this.releaseName = Objects.requireNonNull(releaseName, "releaseName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setReleaseType(AOV3ReleaseKind releaseType) {
            this.releaseType = Objects.requireNonNull(releaseType, "releaseType");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setSource(AOV3Source source) {
            this.source = Objects.requireNonNull(source, "source");
            return this;
        }

        public final Builder setSource(Optional<? extends AOV3Source> source) {
            this.source = source.orElse(null);
            return this;
        }

        public final Builder setTimestamp(OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setUpdatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setVendor(AOV3Vendor vendor) {
            this.vendor = Objects.requireNonNull(vendor, "vendor");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setVersionData(AOV3VersionData versionData) {
            this.versionData = Objects.requireNonNull(versionData, "versionData");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public AOV3Release build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3Release(AOV3Release.createUnmodifiableList(true, this.binaries), this.downloadCount, this.id, this.releaseLink, this.releaseName, this.releaseType, this.source, this.timestamp, this.updatedAt, this.vendor, this.versionData);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("downloadCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("releaseLink");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("releaseName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("releaseType");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("vendor");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("versionData");
            }
            return "Cannot build AOV3Release, some of required attributes are not set " + attributes;
        }
    }
}

