/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3HasNameTextType;

public enum AOV3Vendor implements AOV3HasNameTextType
{
    ADOPT_OPENJDK("adoptopenjdk"),
    OPENJDK("openjdk");

    private final String nameText;

    private AOV3Vendor(String name) {
        this.nameText = Objects.requireNonNull(name, "name");
    }

    public static AOV3Vendor of(String vendor) {
        switch (vendor) {
            case "adoptopenjdk": {
                return ADOPT_OPENJDK;
            }
            case "openjdk": {
                return OPENJDK;
            }
        }
        throw new IllegalStateException("Unexpected value: " + vendor);
    }

    @Override
    public String nameText() {
        return this.nameText;
    }
}

