/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3VersionDataType;

public final class AOV3VersionData
implements AOV3VersionDataType {
    private final BigInteger adoptBuildNumber;
    private final BigInteger build;
    private final BigInteger major;
    private final BigInteger minor;
    private final String openJDKVersion;
    private final String optional;
    private final String pre;
    private final BigInteger security;
    private final String semanticVersion;

    private AOV3VersionData(BigInteger adoptBuildNumber, BigInteger build, BigInteger major, BigInteger minor, String openJDKVersion, String optional, String pre, BigInteger security, String semanticVersion) {
        this.adoptBuildNumber = adoptBuildNumber;
        this.build = build;
        this.major = major;
        this.minor = minor;
        this.openJDKVersion = openJDKVersion;
        this.optional = optional;
        this.pre = pre;
        this.security = security;
        this.semanticVersion = semanticVersion;
    }

    @Override
    public BigInteger adoptBuildNumber() {
        return this.adoptBuildNumber;
    }

    @Override
    public BigInteger build() {
        return this.build;
    }

    @Override
    public BigInteger major() {
        return this.major;
    }

    @Override
    public BigInteger minor() {
        return this.minor;
    }

    @Override
    public String openJDKVersion() {
        return this.openJDKVersion;
    }

    @Override
    public String optional() {
        return this.optional;
    }

    @Override
    public String pre() {
        return this.pre;
    }

    @Override
    public BigInteger security() {
        return this.security;
    }

    @Override
    public String semanticVersion() {
        return this.semanticVersion;
    }

    public final AOV3VersionData withAdoptBuildNumber(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "adoptBuildNumber");
        if (this.adoptBuildNumber.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(newValue, this.build, this.major, this.minor, this.openJDKVersion, this.optional, this.pre, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withBuild(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "build");
        if (this.build.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, newValue, this.major, this.minor, this.openJDKVersion, this.optional, this.pre, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withMajor(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "major");
        if (this.major.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, newValue, this.minor, this.openJDKVersion, this.optional, this.pre, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withMinor(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "minor");
        if (this.minor.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, newValue, this.openJDKVersion, this.optional, this.pre, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withOpenJDKVersion(String value) {
        String newValue = Objects.requireNonNull(value, "openJDKVersion");
        if (this.openJDKVersion.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, this.minor, newValue, this.optional, this.pre, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withOptional(String value) {
        String newValue = Objects.requireNonNull(value, "optional");
        if (this.optional.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, this.minor, this.openJDKVersion, newValue, this.pre, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withPre(String value) {
        String newValue = Objects.requireNonNull(value, "pre");
        if (this.pre.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, this.minor, this.openJDKVersion, this.optional, newValue, this.security, this.semanticVersion);
    }

    public final AOV3VersionData withSecurity(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "security");
        if (this.security.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, this.minor, this.openJDKVersion, this.optional, this.pre, newValue, this.semanticVersion);
    }

    public final AOV3VersionData withSemanticVersion(String value) {
        String newValue = Objects.requireNonNull(value, "semanticVersion");
        if (this.semanticVersion.equals(newValue)) {
            return this;
        }
        return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, this.minor, this.openJDKVersion, this.optional, this.pre, this.security, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3VersionData && this.equalTo((AOV3VersionData)another);
    }

    private boolean equalTo(AOV3VersionData another) {
        return this.adoptBuildNumber.equals(another.adoptBuildNumber) && this.build.equals(another.build) && this.major.equals(another.major) && this.minor.equals(another.minor) && this.openJDKVersion.equals(another.openJDKVersion) && this.optional.equals(another.optional) && this.pre.equals(another.pre) && this.security.equals(another.security) && this.semanticVersion.equals(another.semanticVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.adoptBuildNumber.hashCode();
        h += (h << 5) + this.build.hashCode();
        h += (h << 5) + this.major.hashCode();
        h += (h << 5) + this.minor.hashCode();
        h += (h << 5) + this.openJDKVersion.hashCode();
        h += (h << 5) + this.optional.hashCode();
        h += (h << 5) + this.pre.hashCode();
        h += (h << 5) + this.security.hashCode();
        h += (h << 5) + this.semanticVersion.hashCode();
        return h;
    }

    public String toString() {
        return "AOV3VersionData{adoptBuildNumber=" + this.adoptBuildNumber + ", build=" + this.build + ", major=" + this.major + ", minor=" + this.minor + ", openJDKVersion=" + this.openJDKVersion + ", optional=" + this.optional + ", pre=" + this.pre + ", security=" + this.security + ", semanticVersion=" + this.semanticVersion + "}";
    }

    public static AOV3VersionData copyOf(AOV3VersionDataType instance) {
        if (instance instanceof AOV3VersionData) {
            return (AOV3VersionData)instance;
        }
        return AOV3VersionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ADOPT_BUILD_NUMBER = 1L;
        private static final long INIT_BIT_BUILD = 2L;
        private static final long INIT_BIT_MAJOR = 4L;
        private static final long INIT_BIT_MINOR = 8L;
        private static final long INIT_BIT_OPEN_J_D_K_VERSION = 16L;
        private static final long INIT_BIT_OPTIONAL = 32L;
        private static final long INIT_BIT_PRE = 64L;
        private static final long INIT_BIT_SECURITY = 128L;
        private static final long INIT_BIT_SEMANTIC_VERSION = 256L;
        private long initBits = 511L;
        private BigInteger adoptBuildNumber;
        private BigInteger build;
        private BigInteger major;
        private BigInteger minor;
        private String openJDKVersion;
        private String optional;
        private String pre;
        private BigInteger security;
        private String semanticVersion;

        private Builder() {
        }

        public final Builder from(AOV3VersionDataType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setAdoptBuildNumber(instance.adoptBuildNumber());
            this.setBuild(instance.build());
            this.setMajor(instance.major());
            this.setMinor(instance.minor());
            this.setOpenJDKVersion(instance.openJDKVersion());
            this.setOptional(instance.optional());
            this.setPre(instance.pre());
            this.setSecurity(instance.security());
            this.setSemanticVersion(instance.semanticVersion());
            return this;
        }

        public final Builder setAdoptBuildNumber(BigInteger adoptBuildNumber) {
            this.adoptBuildNumber = Objects.requireNonNull(adoptBuildNumber, "adoptBuildNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBuild(BigInteger build) {
            this.build = Objects.requireNonNull(build, "build");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setMajor(BigInteger major) {
            this.major = Objects.requireNonNull(major, "major");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setMinor(BigInteger minor) {
            this.minor = Objects.requireNonNull(minor, "minor");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setOpenJDKVersion(String openJDKVersion) {
            this.openJDKVersion = Objects.requireNonNull(openJDKVersion, "openJDKVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setOptional(String optional) {
            this.optional = Objects.requireNonNull(optional, "optional");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setPre(String pre) {
            this.pre = Objects.requireNonNull(pre, "pre");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder setSecurity(BigInteger security) {
            this.security = Objects.requireNonNull(security, "security");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder setSemanticVersion(String semanticVersion) {
            this.semanticVersion = Objects.requireNonNull(semanticVersion, "semanticVersion");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public AOV3VersionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3VersionData(this.adoptBuildNumber, this.build, this.major, this.minor, this.openJDKVersion, this.optional, this.pre, this.security, this.semanticVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("adoptBuildNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("build");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("major");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("minor");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("openJDKVersion");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("optional");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("pre");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("security");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("semanticVersion");
            }
            return "Cannot build AOV3VersionData, some of required attributes are not set " + attributes;
        }
    }
}

