/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.ArrayList;
import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3VersionBound;
import net.adoptopenjdk.v3.api.AOV3VersionRangeType;

public final class AOV3VersionRange
implements AOV3VersionRangeType {
    private final AOV3VersionBound lower;
    private final AOV3VersionBound upper;

    private AOV3VersionRange(AOV3VersionBound lower, AOV3VersionBound upper) {
        this.lower = Objects.requireNonNull(lower, "lower");
        this.upper = Objects.requireNonNull(upper, "upper");
    }

    private AOV3VersionRange(AOV3VersionRange original, AOV3VersionBound lower, AOV3VersionBound upper) {
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public AOV3VersionBound lower() {
        return this.lower;
    }

    @Override
    public AOV3VersionBound upper() {
        return this.upper;
    }

    public final AOV3VersionRange withLower(AOV3VersionBound value) {
        if (this.lower == value) {
            return this;
        }
        AOV3VersionBound newValue = Objects.requireNonNull(value, "lower");
        return new AOV3VersionRange(this, newValue, this.upper);
    }

    public final AOV3VersionRange withUpper(AOV3VersionBound value) {
        if (this.upper == value) {
            return this;
        }
        AOV3VersionBound newValue = Objects.requireNonNull(value, "upper");
        return new AOV3VersionRange(this, this.lower, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3VersionRange && this.equalTo((AOV3VersionRange)another);
    }

    private boolean equalTo(AOV3VersionRange another) {
        return this.lower.equals(another.lower) && this.upper.equals(another.upper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lower.hashCode();
        h += (h << 5) + this.upper.hashCode();
        return h;
    }

    public String toString() {
        return "AOV3VersionRange{lower=" + this.lower + ", upper=" + this.upper + "}";
    }

    public static AOV3VersionRange of(AOV3VersionBound lower, AOV3VersionBound upper) {
        return new AOV3VersionRange(lower, upper);
    }

    public static AOV3VersionRange copyOf(AOV3VersionRangeType instance) {
        if (instance instanceof AOV3VersionRange) {
            return (AOV3VersionRange)instance;
        }
        return AOV3VersionRange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LOWER = 1L;
        private static final long INIT_BIT_UPPER = 2L;
        private long initBits = 3L;
        private AOV3VersionBound lower;
        private AOV3VersionBound upper;

        private Builder() {
        }

        public final Builder from(AOV3VersionRangeType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLower(instance.lower());
            this.setUpper(instance.upper());
            return this;
        }

        public final Builder setLower(AOV3VersionBound lower) {
            this.lower = Objects.requireNonNull(lower, "lower");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUpper(AOV3VersionBound upper) {
            this.upper = Objects.requireNonNull(upper, "upper");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AOV3VersionRange build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3VersionRange(null, this.lower, this.upper);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lower");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("upper");
            }
            return "Cannot build AOV3VersionRange, some of required attributes are not set " + attributes;
        }
    }
}

