/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.adoptopenjdk.v3.api.AOV3AvailableReleasesType;

public final class AOV3AvailableReleases
implements AOV3AvailableReleasesType {
    private final List<BigInteger> availableLTSReleases;
    private final List<BigInteger> availableReleases;
    private final BigInteger mostRecentFeatureRelease;
    private final BigInteger mostRecentLTSRelease;

    private AOV3AvailableReleases(List<BigInteger> availableLTSReleases, List<BigInteger> availableReleases, BigInteger mostRecentFeatureRelease, BigInteger mostRecentLTSRelease) {
        this.availableLTSReleases = availableLTSReleases;
        this.availableReleases = availableReleases;
        this.mostRecentFeatureRelease = mostRecentFeatureRelease;
        this.mostRecentLTSRelease = mostRecentLTSRelease;
    }

    @Override
    public List<BigInteger> availableLTSReleases() {
        return this.availableLTSReleases;
    }

    @Override
    public List<BigInteger> availableReleases() {
        return this.availableReleases;
    }

    @Override
    public BigInteger mostRecentFeatureRelease() {
        return this.mostRecentFeatureRelease;
    }

    @Override
    public BigInteger mostRecentLTSRelease() {
        return this.mostRecentLTSRelease;
    }

    public final AOV3AvailableReleases withAvailableLTSReleases(BigInteger ... elements) {
        List<BigInteger> newValue = AOV3AvailableReleases.createUnmodifiableList(false, AOV3AvailableReleases.createSafeList(Arrays.asList(elements), true, false));
        return new AOV3AvailableReleases(newValue, this.availableReleases, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
    }

    public final AOV3AvailableReleases withAvailableLTSReleases(Iterable<? extends BigInteger> elements) {
        if (this.availableLTSReleases == elements) {
            return this;
        }
        List<BigInteger> newValue = AOV3AvailableReleases.createUnmodifiableList(false, AOV3AvailableReleases.createSafeList(elements, true, false));
        return new AOV3AvailableReleases(newValue, this.availableReleases, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
    }

    public final AOV3AvailableReleases withAvailableReleases(BigInteger ... elements) {
        List<BigInteger> newValue = AOV3AvailableReleases.createUnmodifiableList(false, AOV3AvailableReleases.createSafeList(Arrays.asList(elements), true, false));
        return new AOV3AvailableReleases(this.availableLTSReleases, newValue, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
    }

    public final AOV3AvailableReleases withAvailableReleases(Iterable<? extends BigInteger> elements) {
        if (this.availableReleases == elements) {
            return this;
        }
        List<BigInteger> newValue = AOV3AvailableReleases.createUnmodifiableList(false, AOV3AvailableReleases.createSafeList(elements, true, false));
        return new AOV3AvailableReleases(this.availableLTSReleases, newValue, this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
    }

    public final AOV3AvailableReleases withMostRecentFeatureRelease(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "mostRecentFeatureRelease");
        if (this.mostRecentFeatureRelease.equals(newValue)) {
            return this;
        }
        return new AOV3AvailableReleases(this.availableLTSReleases, this.availableReleases, newValue, this.mostRecentLTSRelease);
    }

    public final AOV3AvailableReleases withMostRecentLTSRelease(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "mostRecentLTSRelease");
        if (this.mostRecentLTSRelease.equals(newValue)) {
            return this;
        }
        return new AOV3AvailableReleases(this.availableLTSReleases, this.availableReleases, this.mostRecentFeatureRelease, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3AvailableReleases && this.equalTo((AOV3AvailableReleases)another);
    }

    private boolean equalTo(AOV3AvailableReleases another) {
        return this.availableLTSReleases.equals(another.availableLTSReleases) && this.availableReleases.equals(another.availableReleases) && this.mostRecentFeatureRelease.equals(another.mostRecentFeatureRelease) && this.mostRecentLTSRelease.equals(another.mostRecentLTSRelease);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.availableLTSReleases.hashCode();
        h += (h << 5) + this.availableReleases.hashCode();
        h += (h << 5) + this.mostRecentFeatureRelease.hashCode();
        h += (h << 5) + this.mostRecentLTSRelease.hashCode();
        return h;
    }

    public String toString() {
        return "AOV3AvailableReleases{availableLTSReleases=" + this.availableLTSReleases + ", availableReleases=" + this.availableReleases + ", mostRecentFeatureRelease=" + this.mostRecentFeatureRelease + ", mostRecentLTSRelease=" + this.mostRecentLTSRelease + "}";
    }

    public static AOV3AvailableReleases copyOf(AOV3AvailableReleasesType instance) {
        if (instance instanceof AOV3AvailableReleases) {
            return (AOV3AvailableReleases)instance;
        }
        return AOV3AvailableReleases.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MOST_RECENT_FEATURE_RELEASE = 1L;
        private static final long INIT_BIT_MOST_RECENT_L_T_S_RELEASE = 2L;
        private long initBits = 3L;
        private List<BigInteger> availableLTSReleases = new ArrayList<BigInteger>();
        private List<BigInteger> availableReleases = new ArrayList<BigInteger>();
        private BigInteger mostRecentFeatureRelease;
        private BigInteger mostRecentLTSRelease;

        private Builder() {
        }

        public final Builder from(AOV3AvailableReleasesType instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAvailableLTSReleases(instance.availableLTSReleases());
            this.addAllAvailableReleases(instance.availableReleases());
            this.setMostRecentFeatureRelease(instance.mostRecentFeatureRelease());
            this.setMostRecentLTSRelease(instance.mostRecentLTSRelease());
            return this;
        }

        public final Builder addAvailableLTSReleases(BigInteger element) {
            this.availableLTSReleases.add(Objects.requireNonNull(element, "availableLTSReleases element"));
            return this;
        }

        public final Builder addAvailableLTSReleases(BigInteger ... elements) {
            for (BigInteger element : elements) {
                this.availableLTSReleases.add(Objects.requireNonNull(element, "availableLTSReleases element"));
            }
            return this;
        }

        public final Builder setAvailableLTSReleases(Iterable<? extends BigInteger> elements) {
            this.availableLTSReleases.clear();
            return this.addAllAvailableLTSReleases(elements);
        }

        public final Builder addAllAvailableLTSReleases(Iterable<? extends BigInteger> elements) {
            for (BigInteger bigInteger : elements) {
                this.availableLTSReleases.add(Objects.requireNonNull(bigInteger, "availableLTSReleases element"));
            }
            return this;
        }

        public final Builder addAvailableReleases(BigInteger element) {
            this.availableReleases.add(Objects.requireNonNull(element, "availableReleases element"));
            return this;
        }

        public final Builder addAvailableReleases(BigInteger ... elements) {
            for (BigInteger element : elements) {
                this.availableReleases.add(Objects.requireNonNull(element, "availableReleases element"));
            }
            return this;
        }

        public final Builder setAvailableReleases(Iterable<? extends BigInteger> elements) {
            this.availableReleases.clear();
            return this.addAllAvailableReleases(elements);
        }

        public final Builder addAllAvailableReleases(Iterable<? extends BigInteger> elements) {
            for (BigInteger bigInteger : elements) {
                this.availableReleases.add(Objects.requireNonNull(bigInteger, "availableReleases element"));
            }
            return this;
        }

        public final Builder setMostRecentFeatureRelease(BigInteger mostRecentFeatureRelease) {
            this.mostRecentFeatureRelease = Objects.requireNonNull(mostRecentFeatureRelease, "mostRecentFeatureRelease");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMostRecentLTSRelease(BigInteger mostRecentLTSRelease) {
            this.mostRecentLTSRelease = Objects.requireNonNull(mostRecentLTSRelease, "mostRecentLTSRelease");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AOV3AvailableReleases build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3AvailableReleases(AOV3AvailableReleases.createUnmodifiableList(true, this.availableLTSReleases), AOV3AvailableReleases.createUnmodifiableList(true, this.availableReleases), this.mostRecentFeatureRelease, this.mostRecentLTSRelease);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mostRecentFeatureRelease");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mostRecentLTSRelease");
            }
            return "Cannot build AOV3AvailableReleases, some of required attributes are not set " + attributes;
        }
    }
}

