/*
 * Decompiled with CFR 0.152.
 */
package net.adoptopenjdk.v3.api;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.adoptopenjdk.v3.api.AOV3VersionBoundType;

public final class AOV3VersionBound
implements AOV3VersionBoundType {
    private final String name;
    private final boolean exclusive;

    private AOV3VersionBound(Optional<String> name, boolean exclusive) {
        this.name = name.orElse(null);
        this.exclusive = exclusive;
    }

    private AOV3VersionBound(AOV3VersionBound original, String name, boolean exclusive) {
        this.name = name;
        this.exclusive = exclusive;
    }

    @Override
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    public final AOV3VersionBound withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new AOV3VersionBound(this, newValue, this.exclusive);
    }

    public final AOV3VersionBound withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new AOV3VersionBound(this, value, this.exclusive);
    }

    public final AOV3VersionBound withExclusive(boolean value) {
        if (this.exclusive == value) {
            return this;
        }
        return new AOV3VersionBound(this, this.name, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AOV3VersionBound && this.equalTo((AOV3VersionBound)another);
    }

    private boolean equalTo(AOV3VersionBound another) {
        return Objects.equals(this.name, another.name) && this.exclusive == another.exclusive;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Boolean.hashCode(this.exclusive);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AOV3VersionBound{");
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("exclusive=").append(this.exclusive);
        return builder.append("}").toString();
    }

    public static AOV3VersionBound of(Optional<String> name, boolean exclusive) {
        return new AOV3VersionBound(name, exclusive);
    }

    public static AOV3VersionBound copyOf(AOV3VersionBoundType instance) {
        if (instance instanceof AOV3VersionBound) {
            return (AOV3VersionBound)instance;
        }
        return AOV3VersionBound.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXCLUSIVE = 1L;
        private long initBits = 1L;
        private String name;
        private boolean exclusive;

        private Builder() {
        }

        public final Builder from(AOV3VersionBoundType instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> nameOptional = instance.name();
            if (nameOptional.isPresent()) {
                this.setName(nameOptional);
            }
            this.setExclusive(instance.isExclusive());
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder setExclusive(boolean exclusive) {
            this.exclusive = exclusive;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public AOV3VersionBound build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AOV3VersionBound(null, this.name, this.exclusive);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("exclusive");
            }
            return "Cannot build AOV3VersionBound, some of required attributes are not set " + attributes;
        }
    }
}

