package net.aihelp.common;

import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.init.PrivacyControlEntity;

public class CustomConfig {

    public static class InitSetting {

        // custom texts
        public static String commonPositiveFeedbackHint = "Thanks for your feedback!";
        public static String commonNegativeFeedbackHint = "Thanks for your feedback!";
        public static String csInviteEvaluate = "Please rate our service";

        // control over collecting user device's information
        public static PrivacyControlEntity privacyControlData = null;

        // screen orientation
        public static int screenOrientation = ConfigValues.SCREEN_ORIENTATION_PORTRAIT;
        public static boolean isLandscape = false;

        // toggle of evaluation for FAQ in the customer service module
        public static boolean isEvaluationForBotEnable = false;
        public static boolean isEvaluationForAnswerPageEnable = false;
        public static boolean isEvaluationForOperationEnable = false;
        public static boolean isFaqUnhelpfulFeedbackEnable = false;

        // CustomerService 是否进行确认解决调查、是否开启满意度调查、是否允许邀请评价应用、是否允许差评后反馈
        public static boolean isTicketRatingEnable = true;
        public static boolean isEvaluateBadServiceEnable = true;
        public static int csEvaluateMaxCount = 3;

    }

    public static class CommonSetting {
        // =========================== UI ===========================
        // 导航栏背景色、透明度
        public static String navigationBarBackground = "#FFFFFF";
        public static double navigationBarAlpha = 1;

        // 横竖屏颜色或背景
        public static String backgroundColorForAll = "#FFFFFF";
        public static String backgroundImageForPortrait = "";
        public static String backgroundImageForLandscape = "";

        // 搜索框背景、FAQ列表背景、分类列表背景、机器人消息气泡背景、客服消息气泡背景、表单填写框背景等
        public static String upperBackgroundColor = "#F2F3F4";
        public static double upperBackgroundAlpha = 1;

        // 标题文字、FAQ列表文字、分类列表文字、按钮文字、搜索输入文字、机器人消息文字等
        public static String textColor = "#333940";

        // 通知栏文字、FAQ 搜索关键词
        public static String highlightedColor = "#FA8A1B";

        // 联系客服按钮、提建议按钮、好评差评按钮、机器人Action、超链接等
        public static String interactElementTextColor = "#1B8AFA";

        // whether to render background with image
        public static boolean isBackgroundRenderedWithImage = false;

    }

    public static class HelpCenter {
        // =========================== UI ============================
        // 帮助中心导航栏标题图标
        public static String faqNavigationBarTitleIcon = "";

        // 帮助中心通知栏图标 & 轮播间隔
        public static String faqNotificationIcon = "";
        public static int faqNotificationInterval = 3;

        // 帮助中心热门问题的标题图标 & 分类模块的标题图标
        public static String faqHotTopicTitleIcon = "";
        public static String faqSectionTitleIcon = "";

        // =========================== Toggle ============================
        // Faq 标题 icon 是否可见
        public static boolean isFaqTitleIconVisible = true;

        // Faq 搜索栏是否可见
        public static boolean isFaqSearchVisible = true;

        // Faq 通知栏是否可见、通知栏图标是否可见
        public static boolean isFaqNotificationVisible = true;
        public static boolean isFaqNotificationIconVisible = true;

        // Faq 热门问题模块是否可见、热门模块的标题是否可见、标题图标是否可见、列表项图标是否可见
        public static boolean isFaqHotTopicVisible = true;
        public static boolean isFaqHotTopicTitleVisible = true;
        public static boolean isFaqHotTopicTitleIconVisible = true;
        public static boolean isFaqHotTopicItemIconVisible = true;

        // Faq 分类模块是否可见、分类模块的标题是否可见、标题图标是否可见、列表项图标是否可见、整个模块是否按列表展示
        public static boolean isFaqSectionTitleVisible = true;
        public static boolean isFaqSectionTitleIconVisible = true;
        public static boolean isFaqSectionItemIconVisible = true;
        public static boolean isFaqSectionDisplayAsList = false;

        // =========================== Text ============================
        public static String faqNavigationTitle = "Help Center";
        public static String faqSearchHint = "Please describe your problem";
        public static String faqHotTopicsTitle = "Top Questions";
        public static String faqSectionTitle = "FAQs";
        public static String faqCSEntranceText = "Contact Us";
    }

    public static class CustomerService {
        // =========================== UI ===========================
        // 在线客服导航栏标题图标
        public static String csNavigationBarTitleIcon = "";

        // 在线客服机器人、人工客服以及用户头像
        public static String csBotSupportPortrait = "";
        public static String csManualSupportPortrait = "";
        public static String csUserPortrait = "";

        // =========================== Toggle ===========================
        // CustomerService 头像是否可见、客服昵称是否可见、消息发送时间是否可见、是否允许获取历史消息
        public static boolean isCsTitleIconVisible = false;
        public static boolean isPortraitVisible = false;
        public static boolean isNicknameVisible = false;
        public static boolean isMessageTimestampVisible = false;
        public static boolean isHistoryChatEnable = false;

        // =========================== Text ============================
        public static String csNavigationTitle = "Customer Service";
        public static String csWelcomeMessage = "How can we help you?";
        public static String csInputHint = "Please enter content";

    }

    public static class UploadLimit {

        public static boolean isImageEnableUploading = false;
        public static boolean isVideoEnableUploading = false;
        public static boolean isFileEnableUploading = false;

        public static String imageTypes = "";
        public static String videoTypes = "";
        public static String fileTypes = "";

        public static String rpaAttachmentTypes = "";

        public static int imageMaxSize = 5242880;
        public static int videoMaxSize = 31457280;
        public static int fileMaxSize = 31457280;

    }

    public static void resetTemplateResources() {
        CommonSetting.navigationBarBackground = "#FFFFFF";
        CommonSetting.navigationBarAlpha = 1;
        CommonSetting.backgroundColorForAll = "#FFFFFF";
        CommonSetting.backgroundImageForPortrait = "";
        CommonSetting.backgroundImageForLandscape = "";
        CommonSetting.upperBackgroundColor = "#F2F3F4";
        CommonSetting.upperBackgroundAlpha = 1;
        CommonSetting.textColor = "#333940";
        CommonSetting.highlightedColor = "#FA8A1B";
        CommonSetting.interactElementTextColor = "#1B8AFA";

        HelpCenter.faqNavigationBarTitleIcon = "";
        HelpCenter.faqNotificationIcon = "";
        HelpCenter.faqNotificationInterval = 3;
        HelpCenter.faqHotTopicTitleIcon = "";
        HelpCenter.faqSectionTitleIcon = "";
        HelpCenter.isFaqTitleIconVisible = true;
        HelpCenter.isFaqSearchVisible = true;
        HelpCenter.isFaqNotificationVisible = true;
        HelpCenter.isFaqNotificationIconVisible = true;
        HelpCenter.isFaqHotTopicVisible = true;
        HelpCenter.isFaqHotTopicTitleVisible = true;
        HelpCenter.isFaqHotTopicTitleIconVisible = true;
        HelpCenter.isFaqHotTopicItemIconVisible = true;
        HelpCenter.isFaqSectionTitleVisible = true;
        HelpCenter.isFaqSectionTitleIconVisible = true;
        HelpCenter.isFaqSectionItemIconVisible = true;
        HelpCenter.isFaqSectionDisplayAsList = false;
        HelpCenter.faqNavigationTitle = "Help Center";
        HelpCenter.faqSearchHint = "Please describe your problem";
        HelpCenter.faqHotTopicsTitle = "Top Questions";
        HelpCenter.faqSectionTitle = "FAQs";
        HelpCenter.faqCSEntranceText = "Contact Us";

        CustomerService.csNavigationBarTitleIcon = "";
        CustomerService.csBotSupportPortrait = "";
        CustomerService.csManualSupportPortrait = "";
        CustomerService.csUserPortrait = "";
        CustomerService.isCsTitleIconVisible = false;
        CustomerService.isPortraitVisible = false;
        CustomerService.isNicknameVisible = false;
        CustomerService.isMessageTimestampVisible = false;
        CustomerService.isHistoryChatEnable = false;
        CustomerService.csNavigationTitle = "Customer Service";
        CustomerService.csWelcomeMessage = "How can we help you?";
        CustomerService.csInputHint = "Please enter content";

        FaqHelper.INSTANCE.resetHotTopicAndNotification();
    }

}
