package net.aihelp.common;

import android.content.Context;
import android.content.Intent;

import net.aihelp.config.enums.ShowConversationMoment;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.ui.HostActivity;

public class IntentValues {

    public static final String SUPPORT_MODE = "support_mode";
    public static final String SECTION_ID = "section_id";
    public static final String SECTION_NAME = "section_name";
    public static final String SECTION_ICON = "section_icon";
    public static final String SUB_SECTION_ID = "sub_section_id";
    public static final String OPERATE_SECTION_ID = "operate_section";
    public static final String FAQ_MAIN_ID = "faq_main_id";
    public static final String SEARCH_MATCH = "search_match";
    public static final String FAQ_SUPPORT_MOMENT = "faq_support_moment";
    public static final String CONTACT_US_ALWAYS_ONLINE = "isContactUsAlwaysOnline";
    public static final String SKIP_ELVA_IN_FAQ = "skip_elva_in_faq";
    public static final String INTENT_URL_TITLE = "intent_url_title";
    public static final String INTENT_URL = "intent_url";
    public static final String TASK_CODE = "task_code";

    public static final String BOT_INTENT_LIST = "bot_intent_list";
    public static final String BOT_INTENT_ACTION_NAME = "bot_intent_action_name";

    public static final String BOTTOM_FAQ_CONTENT_ID = "bottom_faq_content_id";
    public static final String BOTTOM_TICKET_FINISHED = "bottom_ticket_finished";
    public static final String BOTTOM_DURING_PROCEDURE = "bottom_during_procedure";
    public static final String BOTTOM_SELF_SERVICE = "bottom_self_service";

    public static final String BOT_EMBEDDED_IN_OPERATION = "bot_embedded_in_operation";
    public static final String HUMAN_EMBEDDED_IN_OPERATION = "HUMAN_embedded_in_operation";

    public static final String OPERATE_SELECT_INDEX = "operate_select_position";
    public static final String OPERATE_SUPPORT_BOT_TITLE = "operate_elva_title";

    public static final String PREVIEW_INFO = "preview_info";

    public static final int MODE_ELVA = 1;
    public static final int MODE_CONVERSATION = 2;
    public static final int MODE_SHOW_SECTION = 3;
    public static final int MODE_SHOW_SINGLE_FAQ = 4;
    public static final int MODE_OPERATE = 5;
    public static final int MODE_URL = 6;
    public static final int MODE_CUSTOMER_SERVICE = 7;
    public static final int MODE_ERROR_ENTRANCE = 8;

    public static final int SHOW_CS_LOADING = 1003;
    public static final int HIDE_CS_LOADING = 1004;

    public static final int SUPPORT_ACTION_FAQ = 1005;
    public static final int SUPPORT_ACTION_MSG = 1006;
    public static final int SUPPORT_ACTION_MSG_UNREAD = 1007;

    public static final int PAGE_HOPPING_CONVERSATION = 1008;
    public static final int PAGE_HOPPING_FORM = 1009;
    public static final int PAGE_HOPPING_TICKET_CONTENT = 1010;

    public static final int REQUEST_CODE_ATTACHMENT = 1001;
    public static final int REQUEST_CODE_PREVIEW = 1002;

    public static Intent getShowErrorEntranceIntent(Context context) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(SUPPORT_MODE, MODE_ERROR_ENTRANCE);
        return intent;
    }

    public static Intent getShowFAQIntent(Context context, ProcessEntity process) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(FAQ_SUPPORT_MOMENT, process.getFaqEntrances());
        return intent;
    }

    public static Intent getShowFAQSectionIntent(Context context, ProcessEntity process) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(SUPPORT_MODE, MODE_SHOW_SECTION);
        intent.putExtra(SECTION_ID, process.getSectionId());
        intent.putExtra(FAQ_SUPPORT_MOMENT, process.getFaqEntrances());
        return intent;
    }

    public static Intent getShowSingleFAQIntent(Context context, ProcessEntity process) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(SUPPORT_MODE, MODE_SHOW_SINGLE_FAQ);
        intent.putExtra(FAQ_MAIN_ID, process.getFaqId());
        intent.putExtra(FAQ_SUPPORT_MOMENT, process.getFaqEntrances());
        return intent;
    }

    public static Intent getShowSingleFAQIntent(Context context, String faqId, ShowConversationMoment moment) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(SUPPORT_MODE, MODE_SHOW_SINGLE_FAQ);
        intent.putExtra(FAQ_MAIN_ID, faqId);
        intent.putExtra(FAQ_SUPPORT_MOMENT, getFaqEntranceByMoment(moment));
        return intent;
    }

    public static Intent getShowCustomerServiceIntent(Context context) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(SUPPORT_MODE, MODE_CUSTOMER_SERVICE);
        return intent;
    }


    public static Intent getUrlIntent(Context context, String url) {
        Intent intent = new Intent(context, HostActivity.class);
        intent.putExtra(SUPPORT_MODE, MODE_URL);
        intent.putExtra(IntentValues.INTENT_URL, url);
        return intent;
    }

    public static Intent wrapForApplicationContext(Intent intent) {
        if (intent != null) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_SINGLE_TOP);
        }
        return intent;
    }

    private static String getFaqEntranceByMoment(ShowConversationMoment moment) {
        switch (moment) {
            case ALWAYS:
            case ONLY_IN_ANSWER_PAGE:
                return ConfigValues.FAQ_SUPPORT_ENTRANCE_ANSWER_PAGE;
            case AFTER_MARKING_UNHELPFUL:
                return ConfigValues.FAQ_SUPPORT_ENTRANCE_AFTER_MARKING_UNHELPFUL;
        }
        return "";
    }

}
