package net.aihelp.config;

import net.aihelp.core.net.json.JsonHelper;

import org.json.JSONObject;

public class ApiConfig {

    private final String entranceId;
    private final String welcomeMessage;

    public static class Builder {
        private String entranceId;
        private String welcomeMessage;

        /**
         * set custom AIHelp entrance id.
         * <p>
         * By default, user can get in touch with customer service in elva bot page only if there is already an ticket opening
         * or she/he submits a form.
         * However, if you set parameter contactUsAlwaysOnline to true, user can always see the contact us button,
         * which means they can get in touch with customer service any time.
         *
         * @param entranceId whether to ALWAYS show contact us button for elva bot page.
         */
        public Builder setEntranceId(String entranceId) {
            this.entranceId = entranceId;
            return this;
        }

        /**
         * set custom welcome message for customer service support
         * <p>
         * You can configure your default welcome msg in aihelp admin dashboard.(http://aihelp.net/dashboard)
         * What's more, you can show different welcome msg by different users with this api.
         *
         * @param welcomeMessage custom welcome msg
         */
        public Builder setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public ApiConfig build(String entranceId, String welcomeMessage) {
            return new ApiConfig(entranceId, welcomeMessage);
        }

        public ApiConfig build() {
            return new ApiConfig(entranceId, welcomeMessage);
        }
    }

    public String getWelcomeMessage() {
        return welcomeMessage;
    }

    public String getEntranceId() {
        return entranceId;
    }

    public ApiConfig(String entranceId, String welcomeMessage) {
        this.entranceId = entranceId;
        this.welcomeMessage = welcomeMessage;
    }

    public JSONObject desc() {
        JSONObject jsonObject = JsonHelper.getJsonObject();
        JsonHelper.put(jsonObject, "entranceId", entranceId);
        JsonHelper.put(jsonObject, "welcomeMessage", welcomeMessage);
        return jsonObject;
    }

}
