package net.aihelp.core.net.http.callback;

import net.aihelp.core.net.http.pojo.ResultEntity;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.crash.logger.AIHelpCrashLogger;
import net.aihelp.utils.TLog;

import java.io.IOException;

import androidx.annotation.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

public class AIHelpCallback<T> implements Callback {

    private final BaseCallback<T> reqCallBack;

    public AIHelpCallback(BaseCallback<T> reqCallBack) {
        this.reqCallBack = reqCallBack;
    }

    @Override
    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        TLog.d("AIHelpCallback onFailure: " + e.toString());
        String requestUrl = call.request().url().toString();
        failedCallBack(call.request(), requestUrl, -1, e.toString(), reqCallBack);
        AIHelpCrashLogger.error(requestUrl, e);
    }

    @Override
    public void onResponse(@NonNull Call call, @NonNull Response response) {

        if (reqCallBack == null) return;
        String requestUrl = call.request().url().toString();

        try {
            if (response.isSuccessful() && response.body() != null) {
                String string = response.body().string();
                if (isUniqueRequest(call, string)) return;
                ResultEntity result = JsonHelper.toJavaObject(string, ResultEntity.class);
                if (null != result) {
                    if (result.isFlag() || result.getCode() == 200) {
                        String data = result.getData();
                        if (null == data || data.equals("")) {
                            successCallBack(null, reqCallBack);
                        } else {
                            if (reqCallBack.getType() == String.class || reqCallBack.getType() == Integer.class ||
                                    reqCallBack.getType() == Double.class || reqCallBack.getType() == Float.class) {
                                successCallBack((T) data, reqCallBack);
                            } else {
                                successCallBack((T) JsonHelper.toJavaObject(data, reqCallBack.getType()), reqCallBack);
                            }
                        }
                    } else {
                        failedCallBack(call.request(), requestUrl, result.getCode(), result.getDesc(), reqCallBack);
                    }
                } else {
                    failedCallBack(call.request(), requestUrl, -1, "ResultEntity is NULL", reqCallBack);
                }
            } else {
                failedCallBack(call.request(), requestUrl, response.code(), response.message(), reqCallBack);
            }
        } catch (Throwable e) {
            TLog.d("AIHelpCallback onResponse catch Exception: " + e.toString());
            failedCallBack(call.request(), requestUrl, -1, e.toString(), reqCallBack);
            AIHelpCrashLogger.error(requestUrl, e);
        }
    }

    private void successCallBack(final T result, final BaseCallback<T> callBack) {
        if (callBack == null) return;
        callBack.onAsyncReqSuccess(result);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                callBack.onReqSuccess(result);
            }
        });
    }

    private void failedCallBack(Request request, final String url, final int errorCode, final String errorMsg, final BaseCallback<T> callBack) {
        if (callBack == null) return;
        callBack.onAsyncFailure(url, errorCode, errorMsg);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                callBack.onFailure(url, errorCode, errorMsg);
            }
        });
    }

    private boolean isUniqueRequest(Call call, String string) {
        String requestUrl = call.request().url().toString();
        if (requestUrl.contains("initset") || requestUrl.contains("getfaqfilenames") || requestUrl.contains("upload")
                || requestUrl.contains("faqs") || requestUrl.contains("crmtoken")
                || requestUrl.contains("sdkconfig") || requestUrl.contains("collect")
                || requestUrl.endsWith(".json")) {
            successCallBack((T) JsonHelper.toJavaObject(string, reqCallBack.getType()), reqCallBack);
            return true;
        }
        return false;
    }

}
