package net.aihelp.core.net.mqtt;

import android.os.Handler;
import android.os.Message;

import net.aihelp.core.net.mqtt.callback.ConnectCallback;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.callback.ReceiveListener;
import net.aihelp.core.net.mqtt.callback.SubscribeCallback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.net.mqtt.client.CallbackConnection;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;

import androidx.annotation.NonNull;

public class AIHelpMqtt {

    private int connectionId;
    private int connectionType;
    private CallbackConnection mqttConnection;
    private CallbackConnection faqMqttConnection;

    public int getMqttConnectionId() {
        return connectionId;
    }

    public void prepare(IMqttCallback callback, int connectionType) {
        this.connectionType = connectionType;
        prepare(MqttConfig.TYPE_RPA, callback);
    }

    public void prepare(int type, IMqttCallback callback) {
        boolean isFaqRequest = type == MqttConfig.TYPE_FAQ;

        connectionId = connectionId + 1;
        mqttConnection = MqttConfig.getInstance().getMqttConnection(isFaqRequest, connectionId);
        mqttConnection.connect(new ConnectCallback(isFaqRequest, callback, connectionId));
        mqttConnection.listener(new ReceiveListener(isFaqRequest, callback, connectionId));
        mqttConnection.subscribe(MqttConfig.getInstance().getTopic(isFaqRequest),
                new SubscribeCallback(isFaqRequest, callback, connectionId, connectionType));

        if (isFaqRequest) {
            onFaqDestroy();
            faqMqttConnection = mqttConnection;
        }

        EventTracker.INSTANCE.log(EventType.CS_CONNECT_MQTT, MqttConfig.getInstance().getMqConfig());
    }

    /**
     * faq 的 mqtt 必须单独处理，无法和客服公用一套逻辑
     * 因为用户可能从 faq 进入客服，而退出客服的时候会断开 mqtt，此时用户在 faq 页面就无法收到 mqtt 推送了
     */
    public void onFaqDestroy() {
        if (faqMqttConnection != null) {
            faqMqttConnection.unregisterListener();
            faqMqttConnection.disconnect(null);
            faqMqttConnection = null;
        }
    }

    public void disconnect() {
        if (mqttConnection != null && mqttConnection.getIdentifier() == connectionId) {
            mqttConnection.unregisterListener();
            mqttConnection.disconnect(null);
            mqttConnection = null;
        }
    }

    public boolean isConnected() {
        return mqttConnection != null && mqttConnection.getIdentifier() == connectionId
                && mqttConnection.transport() != null
                && mqttConnection.transport().isConnected();
    }

    public CallbackConnection getMqttConnection() {
        return mqttConnection;
    }

    public static AIHelpMqtt getInstance() {
        return AIHelpMqtt.Holder.INSTANCE;
    }

    private static class Holder {
        private static final AIHelpMqtt INSTANCE = new AIHelpMqtt();
    }

    private AIHelpMqtt() {
        mConnectingMonitor = new ConnectingHandler();
    }

    private static ConnectingHandler mConnectingMonitor;

    public static class ConnectingHandler extends Handler {
        @Override
        public void handleMessage(@NonNull Message msg) {
//            JSONObject loginParams = LoginMqttHelper.getLoginParams();
//            AIHelpLogger.error(String.format("mqtt[%s] connect for more than 5s.", MqttConfig.getInstance().getMqConfig()),
//                    new IllegalStateException(loginParams.toString()));
        }
    }

}
