package net.aihelp.core.net.mqtt.client;

import net.aihelp.core.net.mqtt.hawtbuf.Buffer;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;

/**
 * <p>
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class Message {

    private final UTF8Buffer topic;
    private final Buffer payload;
    private Callback<Callback<Void>>  onComplete;
    private final DispatchQueue queue;
    boolean blocking = false;

    public Message(DispatchQueue queue, UTF8Buffer topic, Buffer payload, Callback<Callback<Void>> onComplete) {
        this.queue = queue;
        this.payload = payload;
        this.topic = topic;
        this.onComplete = onComplete;
    }

    public byte[] getPayload() {
        return payload.toByteArray();
    }

    /**
     * Using getPayloadBuffer() is lower overhead version of getPayload()
     * since it avoids a byte array copy.
     * @return
     */
    public Buffer getPayloadBuffer() {
        return payload;
    }

    public String getTopic() {
        return topic.toString();
    }

    /**
     * Using getTopicBuffer is lower overhead version of getTopic()
     * since it avoid doing UTF-8 decode.
     * @return
     */
    public UTF8Buffer getTopicBuffer() {
        return topic;
    }

    public void ack() {
        if( blocking ) {
            final Promise<Void> future = new Promise<Void>();
            ack(future);
            try {
                future.await();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            ack(null);
        }
    }

    public void ack(final Callback<Void> onAcked) {
        if(onComplete!=null) {
            queue.execute(new Task() {
                Callback<Callback<Void>> onCompleteCopy = onComplete;
                @Override
                public void run() {
                    onCompleteCopy.onSuccess(onAcked);
                }
            });
            onComplete = null;
        } else {
            if( onAcked!=null ) {
                onAcked.onSuccess(null);
            }
        }
    }

}
