package net.aihelp.core.net.mqtt.client;

/**
 * <p>
 * Function Result that carries one value.
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class ProxyCallback<T> implements Callback<T> {

    public final Callback<T> next;

    public ProxyCallback(Callback<T> next) {
        this.next = next;
    }

    public void onSuccess(T value) {
        if( next!=null ) {
            next.onSuccess(value);
        }
    }

    public void onFailure(Throwable value) {
        if( next!=null ) {
            next.onFailure(value);
        }
    }
}
