package net.aihelp.core.net.mqtt.hawtdispatch.internal;


import net.aihelp.core.net.mqtt.hawtdispatch.Dispatcher;

/**
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
public class DispatcherConfig {

    private static HawtDispatcher defaultDispatcher;

    synchronized public static HawtDispatcher getDefaultDispatcher() {
        if( defaultDispatcher == null ) {
            defaultDispatcher = new DispatcherConfig().createDispatcher();
        }
        return defaultDispatcher;
    }

    private String label="hawtdispatch";
    private int threads = Integer.getInteger("hawtdispatch.threads", Runtime.getRuntime().availableProcessors());
    private boolean profile = Boolean.getBoolean("hawtdispatch.profile");
    private int drains = Integer.getInteger("hawtdispatch.drains", 1000);
    private boolean jmx = "true".equals(System.getProperty("hawtdispatch.jmx", "true").toLowerCase());

    public static Dispatcher create(String name, int threads) {
        DispatcherConfig config = new DispatcherConfig();
        config.label=name;
        config.threads=threads;
        return config.createDispatcher();
    }

    public HawtDispatcher createDispatcher() {
        return new HawtDispatcher(this);
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String name) {
        this.label = name;
    }

    public int getThreads() {
        return threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public boolean isProfile() {
        return profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public int getDrains() {
        return drains;
    }

    public void setDrains(int drains) {
        this.drains = drains;
    }

    public boolean isJmx() {
        return jmx;
    }

    public void setJmx(boolean jmx) {
        this.jmx = jmx;
    }
}
