package net.aihelp.core.net.mqtt.hawtdispatch.internal;

public class HawtThreadGroup extends ThreadGroup {

    private final HawtDispatcher dispatcher;

    public HawtThreadGroup(HawtDispatcher dispatcher, String s) {
        super(s);
        this.dispatcher = dispatcher;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Thread.UncaughtExceptionHandler handler = dispatcher.uncaughtExceptionHandler;
        if( handler!=null ) {
            handler.uncaughtException(thread, throwable);
        } else {
            super.uncaughtException(thread, throwable);
        }
    }
}