package net.aihelp.core.net.mqtt.hawtdispatch.internal;

import java.util.LinkedList;

/**
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
abstract public class WorkerThread extends Thread {

    public abstract ThreadDispatchQueue getDispatchQueue();

    public abstract void unpark();
    public abstract NioManager getNioManager();

    protected WorkerThread() {
    }

    protected WorkerThread(ThreadGroup threadGroup, String s) {
        super(threadGroup, s);
    }

    protected WorkerThread(String s) {
        super(s);
    }

    public static WorkerThread currentWorkerThread() {
        Thread thread = Thread.currentThread();
        if( thread instanceof WorkerThread) {
            return (WorkerThread)thread;
        }
        return null;
    }


    @Override
    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        getDispatchQueue().getDispatcher().setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }
}
