package net.aihelp.core.net.mqtt.util;


import java.util.ArrayList;

/**
 * <p>
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
abstract public class ThreadLocalPool<T> {

    class Pool {
        final ArrayList<T> objects = new ArrayList<T>(maxPoolSizePerThread());
        long hitCounter;
        long missCounter;
//        public void monitor() {
//            DispatchQueue current = Dispatch.getCurrentThreadQueue();
//            if( current!=null ) {
//                current.executeAfter(1, TimeUnit.SECONDS, new Task() {
//                    @Override
//                    public void run() {
//                        if( hitCounter + missCounter > 0 ) {
//                            System.out.println(String.format("Pool stats: %d hits, %d misses =  %f percent",
//                                    hitCounter, missCounter, 100.0*hitCounter/(hitCounter + missCounter)));
//                        }
//                        hitCounter=0;
//                        missCounter=0;
//                        monitor();
//                    }
//                });
//            }
//        }
    }

    private final ThreadLocal<Pool> objectsThreadLocal = new ThreadLocal<Pool>();

    abstract protected T create();

    protected int maxPoolSizePerThread() {
        return 10;
    }

    private Pool getPool() {
        Pool rc = objectsThreadLocal.get();
        if (rc == null) {
            rc = new Pool();
//            rc.monitor();
            objectsThreadLocal.set(rc);
        }
        return rc;
    }

    public T checkout() {
        Pool pool = getPool();
        ArrayList<T> objects = pool.objects;
        if (!objects.isEmpty()) {
            pool.hitCounter++;
            return objects.remove(objects.size() - 1);
        } else {
            pool.missCounter++;
            return create();
        }
    }

    public void checkin(T value) {
        ArrayList<T> objects = getPool().objects;
        if (objects.size() < maxPoolSizePerThread()) {
            objects.add(value);
        }
    }


}
