package net.aihelp.core.ui.adapter;

import android.content.Context;
import android.widget.TextView;

import net.aihelp.BuildConfig;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.List;

public class ErrorBoundaryAdapter<T> implements ItemViewDelegate<T> {

    public ErrorBoundaryAdapter(Context context) {
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_error_boundary");
    }

    @Override
    public boolean isForViewType(T message, int position) {
        return false;
    }

    @Override
    public void convert(ViewHolder holder, T message, int position) {
        if (BuildConfig.DEBUG) {
            TextView tvError = (TextView) holder.getConvertView();
            Styles.reRenderTextView(tvError, "Something is missing here");
        }
    }

    @Override
    public void onDataSourceUpdated(List<T> data) {

    }

}
